/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.crops;

import com.lightning.northstar.content.NorthstarBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.Nullable;

public class VenusVinesBlock
extends Block
implements BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape TIP_SHAPE = Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final BooleanProperty IS_TIP = BooleanProperty.create((String)"is_tip");
    public static final IntegerProperty AGE = BlockStateProperties.AGE_25;
    public static final int MAX_AGE = 25;

    public VenusVinesBlock(BlockBehaviour.Properties prop) {
        super(prop);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)IS_TIP, (Comparable)Boolean.valueOf(true))).setValue((Property)AGE, (Comparable)Integer.valueOf(1)));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (((Boolean)pState.getValue((Property)IS_TIP)).booleanValue()) {
            return TIP_SHAPE;
        }
        return SHAPE;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rando) {
        BlockPos blockpos;
        if ((Integer)state.getValue((Property)AGE) < 25 && CommonHooks.canCropGrow((Level)level, (BlockPos)pos.relative(Direction.DOWN), (BlockState)level.getBlockState(pos.relative(Direction.DOWN)), (rando.nextDouble() < 0.5 ? 1 : 0) != 0) && level.getBlockState(blockpos = pos.relative(Direction.DOWN)).isAir()) {
            level.setBlockAndUpdate(blockpos, this.getGrowIntoState(state, level.random));
            CommonHooks.fireCropGrowPost((Level)level, (BlockPos)blockpos, (BlockState)level.getBlockState(blockpos));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{IS_TIP});
        builder.add(new Property[]{AGE});
    }

    protected BlockState getGrowIntoState(BlockState pState, RandomSource pRandom) {
        if (pRandom.nextInt(4) == 0 && pState.is((Block)NorthstarBlocks.VENUS_VINES.get())) {
            return ((VenusVinesBlock)((Object)NorthstarBlocks.GLOWING_VENUS_VINES.get())).defaultBlockState();
        }
        if (pState.is((Block)NorthstarBlocks.GLOWING_VENUS_VINES.get()) && pRandom.nextInt(2) != 0) {
            return ((VenusVinesBlock)((Object)NorthstarBlocks.VENUS_VINES.get())).defaultBlockState();
        }
        return (BlockState)pState.cycle((Property)AGE);
    }

    public boolean isValidBonemealTarget(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return (Boolean)pState.getValue((Property)IS_TIP);
    }

    public boolean isBonemealSuccess(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void performBonemeal(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        BlockPos blockpos = pPos.relative(Direction.DOWN);
        int i = Math.min((Integer)pState.getValue((Property)AGE) + 1, 25);
        pLevel.setBlockAndUpdate(blockpos, (BlockState)pState.setValue((Property)AGE, (Comparable)Integer.valueOf(i)));
        blockpos = blockpos.relative(Direction.DOWN);
        i = Math.min(i + 1, 25);
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pLevel.getBlockState(pCurrentPos.above()).isAir()) {
            return Blocks.AIR.defaultBlockState();
        }
        if (!pLevel.getBlockState(pCurrentPos.below()).is((Block)NorthstarBlocks.VENUS_VINES.get()) && !pLevel.getBlockState(pCurrentPos.below()).is((Block)NorthstarBlocks.GLOWING_VENUS_VINES.get())) {
            return (BlockState)this.defaultBlockState().setValue((Property)IS_TIP, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)this.defaultBlockState().setValue((Property)IS_TIP, (Comparable)Boolean.valueOf(false));
    }

    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return true;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        if (pContext.getLevel().getBlockState(pContext.getClickedPos().above()).isAir()) {
            return Blocks.AIR.defaultBlockState();
        }
        BlockState belowstate = pContext.getLevel().getBlockState(pContext.getClickedPos().below());
        if (!belowstate.is((Block)NorthstarBlocks.VENUS_VINES.get()) && !belowstate.is((Block)NorthstarBlocks.GLOWING_VENUS_VINES.get())) {
            return (BlockState)this.defaultBlockState().setValue((Property)IS_TIP, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)this.defaultBlockState().setValue((Property)IS_TIP, (Comparable)Boolean.valueOf(false));
    }
}

