/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.lightning.northstar.world.NorthstarOxygen;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ExtinguishedTorchWallBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    protected static final float AABB_OFFSET = 2.5f;
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)13.0, (double)5.0), (Object)Direction.WEST, (Object)Block.box((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)13.0, (double)10.5), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)13.0, (double)10.5)));

    public ExtinguishedTorchWallBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return ExtinguishedTorchWallBlock.getShape(pState);
    }

    public static VoxelShape getShape(BlockState pState) {
        return AABBS.get(pState.getValue((Property)FACING));
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return pFacing.getOpposite() == pState.getValue((Property)FACING) && !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : pState;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction[] adirection;
        BlockState blockstate = this.defaultBlockState();
        Level levelreader = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        for (Direction direction : adirection = pContext.getNearestLookingDirections()) {
            Direction direction1;
            if (!direction.getAxis().isHorizontal() || !(blockstate = (BlockState)blockstate.setValue((Property)FACING, (Comparable)(direction1 = direction.getOpposite()))).canSurvive((LevelReader)levelreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        BlockPos blockpos = pPos.relative(direction.getOpposite());
        BlockState blockstate = pLevel.getBlockState(blockpos);
        return blockstate.isFaceSturdy((BlockGetter)pLevel, blockpos, direction);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean fireflag = false;
        if ((stack.getItem() == Items.FLINT_AND_STEEL || stack.getItem() == Items.FIRE_CHARGE) && NorthstarOxygen.hasOxygen(level, (Vec3i)pos)) {
            fireflag = true;
        }
        if (player.getAbilities().mayBuild && fireflag) {
            level.setBlock(pos, (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)((Direction)state.getValue((Property)FACING))), 64);
            level.playSound(player, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.8f);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING});
    }
}

