/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.block.simple.CrystalBlock;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.content.NorthstarSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public class LaserBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty DIRECTION = BlockStateProperties.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final IntegerProperty POWER = BlockStateProperties.LEVEL;

    public LaserBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)DIRECTION, (Comparable)Direction.UP)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)POWER, (Comparable)Integer.valueOf(1)));
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        LaserBlock.updateColumn((LevelAccessor)pLevel, pPos, pState, pLevel.getBlockState(pPos.relative(((Direction)pState.getValue((Property)DIRECTION)).getOpposite())));
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        double d0 = pPos.getX();
        double d1 = pPos.getY();
        double d2 = pPos.getZ();
        if (pRandom.nextInt(200) == 0) {
            pLevel.playLocalSound(d0, d1, d2, (SoundEvent)NorthstarSounds.LASER_AMBIENT.get(), SoundSource.BLOCKS, 0.2f + pRandom.nextFloat() * 0.2f, 0.9f + pRandom.nextFloat() * 0.15f, false);
        }
    }

    public static void updateColumn(LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
        LaserBlock.updateColumn(pLevel, pPos, pLevel.getBlockState(pPos), pState);
    }

    public static void updateColumn(LevelAccessor pLevel, BlockPos pPos, BlockState pLaser, BlockState pState) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.mutable();
        BlockState blockstate = LaserBlock.getLaserState(pState, (Level)pLevel, pPos);
        Direction dir = pState.is((Block)NorthstarBlocks.LASER.get()) || pState.is((Block)NorthstarBlocks.AMETHYST_CRYSTAL.get()) ? (Direction)pState.getValue((Property)DIRECTION) : (pState.is(Blocks.AIR) ? (Direction)pLaser.getValue((Property)DIRECTION) : Direction.DOWN);
        if (pState.getBlock() == NorthstarBlocks.LASER_LENSE.get()) {
            blockpos$mutableblockpos = pPos.below().mutable();
        }
        while (pLevel.getBlockState((BlockPos)blockpos$mutableblockpos) == Blocks.AIR.defaultBlockState() || pLevel.getBlockState((BlockPos)blockpos$mutableblockpos).getBlock() == NorthstarBlocks.LASER.get() || pLevel.getBlockState((BlockPos)blockpos$mutableblockpos).getBlock() == NorthstarBlocks.AMETHYST_CRYSTAL.get()) {
            boolean crystal_flag;
            if (pLevel.getBlockState((BlockPos)blockpos$mutableblockpos).getBlock() == NorthstarBlocks.AMETHYST_CRYSTAL.get()) {
                crystal_flag = true;
                if (pLevel.getBlockState((BlockPos)blockpos$mutableblockpos).getValue((Property)CrystalBlock.FACING) == dir.getOpposite()) {
                    return;
                }
                dir = (Direction)pLevel.getBlockState((BlockPos)blockpos$mutableblockpos).getValue((Property)CrystalBlock.FACING);
                if (blockstate.getBlock() != Blocks.AIR) {
                    blockstate = (BlockState)blockstate.setValue((Property)DIRECTION, (Comparable)dir);
                }
                blockpos$mutableblockpos.move(dir);
                Northstar.LOGGER.debug("AMETHYST DETECTED!");
            } else {
                crystal_flag = false;
            }
            if (blockstate != Blocks.AIR.defaultBlockState() && !crystal_flag) {
                blockstate = (BlockState)blockstate.setValue((Property)DIRECTION, (Comparable)dir);
            }
            if (!pLevel.setBlock((BlockPos)blockpos$mutableblockpos, blockstate, 2) && crystal_flag) {
                return;
            }
            blockpos$mutableblockpos.move(dir);
        }
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (!pEntity.fireImmune()) {
            pEntity.setRemainingFireTicks(pEntity.getRemainingFireTicks() + 1);
            if (pEntity.getRemainingFireTicks() == 0) {
                pEntity.setRemainingFireTicks(8);
            }
        }
        pEntity.hurt(pLevel.damageSources().inFire(), 4.0f);
        super.entityInside(pState, pLevel, pPos, pEntity);
    }

    private static BlockState getLaserState(BlockState pBlockState, Level level, BlockPos pos) {
        if (pBlockState.is((Block)NorthstarBlocks.LASER.get())) {
            return pBlockState;
        }
        if (pBlockState.is((Block)NorthstarBlocks.LASER_LENSE.get())) {
            return NorthstarBlocks.LASER.getDefaultState();
        }
        if (pBlockState.is((Block)NorthstarBlocks.AMETHYST_CRYSTAL.get())) {
            int count = 0;
            BlockPos.MutableBlockPos blockpos = pos.mutable();
            for (Direction direction : Direction.values()) {
                blockpos.setWithOffset((Vec3i)pos, direction);
                if (!level.getBlockState((BlockPos)blockpos).is((Block)NorthstarBlocks.LASER.get())) continue;
                ++count;
            }
            if (count > 1) {
                return (BlockState)NorthstarBlocks.LASER.getDefaultState().setValue((Property)DIRECTION, (Comparable)((Direction)pBlockState.getValue((Property)CrystalBlock.FACING)));
            }
            return Blocks.AIR.defaultBlockState();
        }
        return Blocks.AIR.defaultBlockState();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{DIRECTION, WATERLOGGED, POWER});
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction direction = (Direction)pState.getValue((Property)DIRECTION);
        BlockPos blockpos = pPos.relative(direction.getOpposite());
        if (direction != Direction.DOWN) {
            Northstar.LOGGER.debug("{}", (Object)pLevel.getBlockState(blockpos).is((Block)NorthstarBlocks.AMETHYST_CRYSTAL.get()));
            return true;
        }
        return pLevel.getBlockState(blockpos).is((Block)NorthstarBlocks.LASER.get()) || pLevel.getBlockState(blockpos).is((Block)NorthstarBlocks.LASER_LENSE.get()) || pLevel.getBlockState(blockpos).is((Block)NorthstarBlocks.AMETHYST_CRYSTAL.get());
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)DIRECTION, (Comparable)pContext.getClickedFace());
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)DIRECTION, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)DIRECTION)));
    }

    public PushReaction getPistonPushReaction(BlockState pState) {
        return PushReaction.DESTROY;
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        pLevel.scheduleTick(pPos, (Block)this, 0);
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        pLevel.scheduleTick(pCurrentPos, (Block)this, 1);
        return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }
}

