/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.lightning.northstar.block.entity.OxygenBubbleGeneratorBlockEntity;
import com.lightning.northstar.content.NorthstarBlockEntityTypes;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.jetbrains.annotations.Nullable;

public class OxygenBubbleGeneratorBlock
extends BaseEntityBlock
implements IBE<OxygenBubbleGeneratorBlockEntity> {
    private static final MapCodec<OxygenBubbleGeneratorBlock> CODEC = OxygenBubbleGeneratorBlock.simpleCodec(OxygenBubbleGeneratorBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public OxygenBubbleGeneratorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{POWERED});
    }

    public Class<OxygenBubbleGeneratorBlockEntity> getBlockEntityClass() {
        return OxygenBubbleGeneratorBlockEntity.class;
    }

    public BlockEntityType<? extends OxygenBubbleGeneratorBlockEntity> getBlockEntityType() {
        return (BlockEntityType)NorthstarBlockEntityTypes.OXYGEN_BUBBLE_GENERATOR.get();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return OxygenBubbleGeneratorBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)NorthstarBlockEntityTypes.OXYGEN_BUBBLE_GENERATOR.get()), OxygenBubbleGeneratorBlockEntity::tick);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH);
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        boolean flag;
        if (!pLevel.isClientSide && (flag = ((Boolean)pState.getValue((Property)POWERED)).booleanValue()) != pLevel.hasNeighborSignal(pPos)) {
            if (flag) {
                pLevel.scheduleTick(pPos, (Block)this, 4);
            } else {
                pLevel.setBlock(pPos, (BlockState)pState.cycle((Property)POWERED), 2);
            }
        }
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.getValue((Property)POWERED)).booleanValue() && !pLevel.hasNeighborSignal(pPos)) {
            pLevel.setBlock(pPos, (BlockState)pState.cycle((Property)POWERED), 2);
        }
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

