/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.combustion_engine;

import com.lightning.northstar.block.tech.combustion_engine.CombustionEngineBlockEntity;
import com.lightning.northstar.block.tech.combustion_engine.CombustionEngineVisual;
import com.lightning.northstar.block.tech.solar_panel.SolarPanelBlock;
import com.lightning.northstar.content.NorthstarPartialModels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class CombustionEngineRenderer
extends KineticBlockEntityRenderer<CombustionEngineBlockEntity> {
    public CombustionEngineRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(CombustionEngineBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            return;
        }
        Direction facing = (Direction)be.getBlockState().getValue(SolarPanelBlock.HORIZONTAL_FACING);
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel()) * Math.signum(be.getSpeed()) * 2.0f;
        SuperByteBuffer shaft = CachedBuffers.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)be.getBlockState(), (Direction)facing.getOpposite());
        CombustionEngineRenderer.standardKineticRotationTransform((SuperByteBuffer)shaft, (KineticBlockEntity)be, (int)light).renderInto(ms, buffer.getBuffer(RenderType.solid()));
        this.renderPiston(be, ms, buffer, light, facing, NorthstarPartialModels.PISTON1, time + 0.0f);
        this.renderPiston(be, ms, buffer, light, facing, NorthstarPartialModels.PISTON2, time + 2.0f);
        this.renderPiston(be, ms, buffer, light, facing, NorthstarPartialModels.PISTON3, time + 4.0f);
        this.renderPiston(be, ms, buffer, light, facing, NorthstarPartialModels.PISTON4, time + 8.0f);
        this.renderPiston(be, ms, buffer, light, facing, NorthstarPartialModels.PISTON5, time + 10.0f);
        this.renderPiston(be, ms, buffer, light, facing, NorthstarPartialModels.PISTON6, time + 12.0f);
    }

    private void renderPiston(CombustionEngineBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light, Direction facing, PartialModel model, float time) {
        ((SuperByteBuffer)CachedBuffers.partialFacing((PartialModel)model, (BlockState)be.getBlockState(), (Direction)facing).translate(0.0f, CombustionEngineVisual.getPistonOffset(time), 0.0f)).light(light).renderInto(ms, buffer.getBuffer(RenderType.solid()));
    }
}

