/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.combustion_engine;

import com.lightning.northstar.block.tech.combustion_engine.CombustionEngineBlock;
import com.lightning.northstar.block.tech.combustion_engine.CombustionEngineBlockEntity;
import com.lightning.northstar.content.NorthstarPartialModels;
import com.mojang.math.Axis;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.SingleAxisRotatingVisual;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class CombustionEngineVisual
extends SingleAxisRotatingVisual<CombustionEngineBlockEntity>
implements SimpleDynamicVisual {
    private final OrientedInstance piston1;
    private final OrientedInstance piston2;
    private final OrientedInstance piston3;
    private final OrientedInstance piston4;
    private final OrientedInstance piston5;
    private final OrientedInstance piston6;

    public CombustionEngineVisual(VisualizationContext context, CombustionEngineBlockEntity entity, float partialTick) {
        super(context, (KineticBlockEntity)entity, partialTick, Direction.SOUTH, Models.partial((PartialModel)AllPartialModels.SHAFT_HALF));
        Quaternionf rotation = Axis.YP.rotationDegrees(AngleHelper.horizontalAngle((Direction)((Direction)this.blockState.getValue(CombustionEngineBlock.HORIZONTAL_FACING))));
        this.piston1 = ((OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)NorthstarPartialModels.PISTON1)).createInstance()).rotate((Quaternionfc)rotation);
        this.piston2 = ((OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)NorthstarPartialModels.PISTON2)).createInstance()).rotate((Quaternionfc)rotation);
        this.piston3 = ((OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)NorthstarPartialModels.PISTON3)).createInstance()).rotate((Quaternionfc)rotation);
        this.piston4 = ((OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)NorthstarPartialModels.PISTON4)).createInstance()).rotate((Quaternionfc)rotation);
        this.piston5 = ((OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)NorthstarPartialModels.PISTON5)).createInstance()).rotate((Quaternionfc)rotation);
        this.piston6 = ((OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)NorthstarPartialModels.PISTON6)).createInstance()).rotate((Quaternionfc)rotation);
        this.beginFrame(null);
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)this.level) * Math.signum(((CombustionEngineBlockEntity)this.blockEntity).getSpeed()) * 2.0f;
        this.piston1.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, CombustionEngineVisual.getPistonOffset(time), 0.0f).setChanged();
        this.piston2.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, CombustionEngineVisual.getPistonOffset(time + 2.0f), 0.0f).setChanged();
        this.piston3.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, CombustionEngineVisual.getPistonOffset(time + 4.0f), 0.0f).setChanged();
        this.piston4.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, CombustionEngineVisual.getPistonOffset(time + 8.0f), 0.0f).setChanged();
        this.piston5.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, CombustionEngineVisual.getPistonOffset(time + 10.0f), 0.0f).setChanged();
        this.piston6.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, CombustionEngineVisual.getPistonOffset(time + 12.0f), 0.0f).setChanged();
    }

    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight(new FlatLit[]{this.piston1, this.piston2, this.piston3, this.piston4, this.piston5, this.piston6});
    }

    protected void _delete() {
        super._delete();
        this.piston1.delete();
        this.piston2.delete();
        this.piston3.delete();
        this.piston4.delete();
        this.piston5.delete();
        this.piston6.delete();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept((Instance)this.piston1);
        consumer.accept((Instance)this.piston2);
        consumer.accept((Instance)this.piston3);
        consumer.accept((Instance)this.piston4);
        consumer.accept((Instance)this.piston5);
        consumer.accept((Instance)this.piston6);
    }

    public static float getPistonOffset(double time) {
        return (float)(Math.sin(time) * (double)0.05f);
    }
}

