/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.oxygen_concentrator;

import com.lightning.northstar.block.tech.oxygen_concentrator.OxygenConcentratorBlock;
import com.lightning.northstar.content.NorthstarBlockEntityTypes;
import com.lightning.northstar.content.NorthstarFluids;
import com.lightning.northstar.world.dimension.NorthstarDimensions;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class OxygenConcentratorBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    public int airLevel;
    public int airTimer;
    public SmartFluidTankBehaviour tank;

    public OxygenConcentratorBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)NorthstarBlockEntityTypes.OXYGEN_CONCENTRATOR.get(), (be, face) -> {
            if (face == ((Direction)be.getBlockState().getValue(OxygenConcentratorBlock.HORIZONTAL_FACING)).getOpposite()) {
                return be.tank.getCapability();
            }
            return null;
        });
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (super.addToGoggleTooltip(tooltip, isPlayerSneaking)) {
            tooltip.add((Component)Component.empty());
        }
        this.containedFluidTooltip(tooltip, isPlayerSneaking, this.tank.getCapability());
        return true;
    }

    public void tick() {
        super.tick();
        if (this.speed == 0.0f || this.overStressed) {
            return;
        }
        float abs = Math.abs(this.getSpeed());
        int increment = Mth.clamp((int)(((int)abs - 100) / 200), (int)1, (int)5);
        this.airLevel = Math.min(500, this.airLevel + increment);
        ResourceKey dimension = this.level.dimension();
        if (dimension.equals(Level.OVERWORLD)) {
            this.tank.getPrimaryHandler().fill(new FluidStack((Fluid)NorthstarFluids.OXYGEN.get(), increment), IFluidHandler.FluidAction.EXECUTE);
        } else if (dimension.equals(NorthstarDimensions.MARS_DIM_KEY) || dimension.equals(NorthstarDimensions.VENUS_DIM_KEY)) {
            this.tank.getPrimaryHandler().fill(new FluidStack((Fluid)NorthstarFluids.CARBON.get(), increment), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putInt("Air", this.airLevel);
        compound.putInt("Timer", this.airTimer);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.airLevel = compound.getInt("Air");
        this.airTimer = compound.getInt("Timer");
    }
}

