/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.telescope;

import com.lightning.northstar.block.tech.telescope.TelescopeMenu;
import com.lightning.northstar.content.NorthstarDataComponents;
import com.lightning.northstar.content.NorthstarItems;
import com.lightning.northstar.world.dimension.NorthstarPlanets;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TelescopeBlockEntity
extends SmartBlockEntity
implements MenuProvider {
    public TelescopeBlockEntity(BlockEntityType<TelescopeBlockEntity> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return TelescopeMenu.create(id, inventory, this);
    }

    public void print(String name, ServerPlayer player) {
        boolean foundPaper = false;
        Inventory inventory = player.getInventory();
        for (int i = 0; i < inventory.items.size(); ++i) {
            ItemStack item = (ItemStack)inventory.items.get(i);
            if (!item.is(Items.PAPER)) continue;
            item.setCount(item.getCount() - 1);
            foundPaper = true;
            break;
        }
        if (!foundPaper && !player.isCreative()) {
            return;
        }
        player.level().playSound((Player)player, this.getBlockPos(), SoundEvents.UI_CARTOGRAPHY_TABLE_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
        int x = (int)NorthstarPlanets.getPlanetX(name);
        int y = (int)NorthstarPlanets.getPlanetY(name);
        ItemStack reading = new ItemStack((ItemLike)NorthstarItems.ASTRONOMICAL_READING.get(), 1);
        reading.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)("item.northstar.reading_" + name)).setStyle(Style.EMPTY.withColor(ChatFormatting.WHITE).withItalic(Boolean.valueOf(false))));
        reading.set(DataComponents.LORE, (Object)new ItemLore(List.of(Component.literal((String)("X: " + x)).setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(false))), Component.literal((String)("Y: " + y)).setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(false))))));
        reading.set(NorthstarDataComponents.PLANET, (Object)name);
        reading.set(NorthstarDataComponents.PLANET_X, (Object)x);
        reading.set(NorthstarDataComponents.PLANET_Y, (Object)y);
        this.level.addFreshEntity((Entity)new ItemEntity(this.level, player.getX(), player.getY(), player.getZ(), reading));
    }

    public Component getDisplayName() {
        return Component.literal((String)"Telescope");
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }
}

