/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.temperature_regulator;

import com.lightning.northstar.block.tech.temperature_regulator.BaseTemperatureRegulator;
import com.lightning.northstar.config.NorthstarConfigs;
import com.lightning.northstar.particle.SnowflakeParticleData;
import com.lightning.northstar.util.NorthstarLang;
import com.lightning.northstar.util.TemperatureUnit;
import com.lightning.northstar.world.NorthstarTemperature;
import com.lightning.northstar.world.sealer.ProgressiveBlockSealer;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TemperatureRegulatorBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation,
IHaveHoveringInformation,
NorthstarTemperature.Provider {
    public static final int MAX_LIMIT_SIZE = 5;
    protected final BaseTemperatureRegulator regulator = new BaseTemperatureRegulator();
    protected int sealCooldown;
    protected boolean active;

    public TemperatureRegulatorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void initialize() {
        super.initialize();
        this.level.northstar$temperature().registerSealer(this);
    }

    public void invalidate() {
        super.invalidate();
        this.level.northstar$temperature().unregisterSealer(this);
    }

    public void tick() {
        super.tick();
        ProgressiveBlockSealer sealer = this.regulator.sealer;
        if (sealer.isSealInProgress()) {
            if (sealer.updateSeal(this.level, this.getMaximumSealedBlocks())) {
                this.sealCooldown = (Integer)NorthstarConfigs.server().sealerCheckDelay.get();
            }
        } else if (this.sealCooldown-- <= 0) {
            sealer.beginSeal(this.level, this.worldPosition, null);
        }
        boolean bl = this.active = Math.abs(this.speed) > 0.0f && !this.overStressed && !sealer.hasLeak();
        if (this.active && this.level.isClientSide) {
            this.addParticles(this.isCurrentlyWarm(), this.speed / 64.0f);
        }
    }

    public int getMaximumSealedBlocks() {
        return (int)((float)((Integer)NorthstarConfigs.server().temperatureRegulatorBlocksPerRpm.get()).intValue() * Math.abs(this.speed));
    }

    public boolean isCurrentlyWarm() {
        return this.regulator.temperature >= NorthstarTemperature.getBaseTemperature(this.level, this.worldPosition);
    }

    @Override
    public boolean isSealed(Vec3 pos) {
        return this.isSealed(Mth.floor((double)pos.x), Mth.floor((double)pos.y), Mth.floor((double)pos.z));
    }

    @Override
    public boolean isSealed(Vec3i pos) {
        return this.isSealed(pos.getX(), pos.getY(), pos.getZ());
    }

    private boolean isSealed(int x, int y, int z) {
        return this.active && this.regulator.sealer.getSealedBlocks().contains(BlockPos.asLong((int)x, (int)y, (int)z));
    }

    @Override
    public float getTemperature() {
        return this.regulator.temperature;
    }

    public void addParticles(boolean isWarm, float spinMod) {
        RandomSource random = this.level.getRandom();
        if (isWarm) {
            spinMod = 1.0f;
        }
        int j = random.nextInt(isWarm ? 5 : 4);
        for (int i = 0; i < j; ++i) {
            Object particle = isWarm ? ParticleTypes.FLAME : new SnowflakeParticleData();
            double posX = (double)this.worldPosition.getX() + random.nextDouble();
            double posY = (double)this.worldPosition.getY() + 0.7 + random.nextDouble();
            double posZ = (double)this.worldPosition.getZ() + random.nextDouble();
            double velX = (double)random.nextFloat() * 0.05 * (double)(random.nextBoolean() ? -1 : 1) * (double)spinMod;
            double velY = (double)random.nextFloat() * (isWarm ? 0.05 : -0.08);
            double velZ = (double)random.nextFloat() * 0.05 * (double)(random.nextBoolean() ? -1 : 1) * (double)spinMod;
            this.level.addParticle((ParticleOptions)particle, posX, posY, posZ, velX, velY, velZ);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (super.addToGoggleTooltip(tooltip, isPlayerSneaking)) {
            tooltip.add((Component)Component.empty());
        }
        NorthstarLang.translate("gui.goggles.temperature_regulator", new Object[0]).forGoggles(tooltip);
        NorthstarLang.translate("gui.goggles.temperature", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        TemperatureUnit unit = (TemperatureUnit)((Object)NorthstarConfigs.client().temperatureUnit.get());
        CreateLang.number((double)unit.fromCelsius(this.regulator.temperature)).style(ChatFormatting.AQUA).text(ChatFormatting.GRAY, unit.symbol).forGoggles(tooltip, 1);
        this.regulator.sealer.addToGoggleTooltip(tooltip, this.getMaximumSealedBlocks());
        if (isPlayerSneaking) {
            this.regulator.sealer.addCooldownTooltip(tooltip, this.sealCooldown, this.getMaximumSealedBlocks());
        }
        return true;
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        this.regulator.write(compound);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.regulator.read(compound, this.worldPosition);
    }

    public ProgressiveBlockSealer getSealer() {
        return this.regulator.sealer;
    }
}

