/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.client;

import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BasicTickableSoundInstance
extends AbstractTickableSoundInstance {
    private BlockEntity entity;

    public BasicTickableSoundInstance(SoundEvent soundEvent, SoundSource source, RandomSource random, BlockEntity entity) {
        super(soundEvent, source, random);
        this.entity = entity;
        this.setPos(entity.getBlockPos());
    }

    public void tick() {
        if (this.entity.isRemoved()) {
            this.stop();
        }
    }

    public void cancel() {
        this.stop();
    }

    public void setPos(BlockPos pos) {
        this.x = (double)pos.getX() + 0.5;
        this.y = (double)pos.getY() + 0.5;
        this.z = (double)pos.getZ() + 0.5;
    }

    public void setPos(Vec3 pos) {
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
    }

    public void setLooping(boolean looping) {
        this.looping = looping;
    }
}

