/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.contraption.rocket;

import com.lightning.northstar.contraption.rocket.RocketContraptionEntity;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RocketAirSound
extends AbstractTickableSoundInstance {
    private float pitch;
    private RocketContraptionEntity parent;

    public RocketAirSound(SoundEvent snd, float pitch, RocketContraptionEntity pParent) {
        super(snd, SoundSource.BLOCKS, SoundInstance.createUnseededRandom());
        this.pitch = pitch;
        this.parent = pParent;
        this.volume = 0.01f;
        this.looping = true;
        this.delay = 0;
        this.relative = true;
    }

    public void tick() {
        this.x = this.parent.getX();
        this.y = this.parent.getY();
        this.z = this.parent.getZ();
        if (this.parent.isRemoved()) {
            this.stop();
        }
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public void setVolume(float vol) {
        this.volume = vol;
    }

    public void fadeIn(float maxVolume) {
        this.volume = Math.min(maxVolume, this.volume + 0.05f);
    }

    public void fadeOut() {
        this.volume = Math.max(0.0f, this.volume - 0.05f);
    }

    public boolean isFaded() {
        return this.volume == 0.0f;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void stopSound() {
        this.stop();
    }
}

