/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.entity.MarsToadEntity;
import com.lightning.northstar.entity.MarsWormAi;
import com.lightning.northstar.entity.goals.LayEggInNestGoal;
import java.util.Collections;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.warden.AngerManagement;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MarsWormEntity
extends Monster
implements GeoAnimatable,
VibrationSystem {
    private static final ResourceLocation SPEED_MODIFIER_ATTACKING_ID = Northstar.asResource("attacking");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_ID, 0.2, AttributeModifier.Operation.ADD_VALUE);
    private static final EntityDataAccessor<Integer> CLIENT_ANGER_LEVEL = SynchedEntityData.defineId(MarsWormEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final AnimatableInstanceCache animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final DynamicGameEventListener<VibrationSystem.Listener> dynamicGameEventListener;
    private final VibrationSystem.User vibrationUser;
    private VibrationSystem.Data vibrationData;
    private boolean aggro;
    private int angerTimer = 0;
    public int eggTimer = 0;
    private LivingEntity notTarget;
    private UUID notTargetUUID;
    private int attackTick;
    private AngerManagement angerManagement = new AngerManagement(this::canTargetEntity, Collections.emptyList());

    public MarsWormEntity(EntityType<? extends MarsWormEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.getAttribute(Attributes.STEP_HEIGHT).setBaseValue(1.0);
        this.dynamicGameEventListener = new DynamicGameEventListener((GameEventListener)new VibrationSystem.Listener((VibrationSystem)this));
        this.vibrationUser = new VibrationUser();
        this.vibrationData = new VibrationSystem.Data();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public double getTick(Object object) {
        return this.tickCount;
    }

    private PlayState predicate(AnimationState<MarsWormEntity> event) {
        AnimationController controller = event.getController();
        if (this.attackTick > 0) {
            --this.attackTick;
            controller.setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().then("bite", Animation.LoopType.PLAY_ONCE));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            controller.setAnimationSpeed((double)event.getLimbSwingAmount()).setAnimation(RawAnimation.begin().thenLoop("walk"));
        } else {
            controller.setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    @NotNull
    public VibrationSystem.Data getVibrationData() {
        return this.vibrationData;
    }

    @NotNull
    public VibrationSystem.User getVibrationUser() {
        return this.vibrationUser;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f);
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 4) {
            this.attackTick = 40;
        } else {
            super.handleEntityEvent(pId);
        }
    }

    public static boolean wormSpawnRules(EntityType<MarsWormEntity> cobra, LevelAccessor level, MobSpawnType spawntype, BlockPos pos, RandomSource rando) {
        int surfaceY = level.getHeight(Heightmap.Types.MOTION_BLOCKING, pos.getX(), pos.getZ());
        BlockState state = level.getBlockState(pos.below());
        if (pos.getY() >= surfaceY) {
            return false;
        }
        if ((double)pos.getY() < (double)surfaceY / 2.5) {
            int light = level.getMaxLocalRawBrightness(pos);
            return light != 0 ? false : MarsWormEntity.checkMobSpawnRules(cobra, (LevelAccessor)level, (MobSpawnType)spawntype, (BlockPos)pos, (RandomSource)rando) && state.is(NorthstarTags.NorthstarBlockTags.NATURAL_MARS_BLOCKS.tag);
        }
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CLIENT_ANGER_LEVEL, (Object)0);
    }

    public int getClientAngerLevel() {
        return (Integer)this.entityData.get(CLIENT_ANGER_LEVEL);
    }

    public void updateDynamicGameEventListener(BiConsumer<DynamicGameEventListener<?>, ServerLevel> pListenerConsumer) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            pListenerConsumer.accept(this.dynamicGameEventListener, serverlevel);
        }
    }

    private void syncClientAngerLevel() {
        this.entityData.set(CLIENT_ANGER_LEVEL, (Object)this.getActiveAnger());
    }

    private int getActiveAnger() {
        return this.angerManagement.getActiveAnger((Entity)this.getTarget());
    }

    public void tick() {
        Level level = this.level();
        if (this.eggTimer > 0) {
            --this.eggTimer;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (this.notTargetUUID != null) {
                this.notTarget = (LivingEntity)serverlevel.getEntity(this.notTargetUUID);
                this.notTargetUUID = null;
            }
            VibrationSystem.Ticker.tick((Level)serverlevel, (VibrationSystem.Data)this.vibrationData, (VibrationSystem.User)this.vibrationUser);
            if (this.getTarget() != null && this.angerTimer > 0 && (double)this.getTarget().distanceTo((Entity)this) > this.getAttributeValue(Attributes.FOLLOW_RANGE)) {
                --this.angerTimer;
            }
            if (this.getTarget() != null) {
                Player plyr;
                LivingEntity livingEntity;
                if (this.getTarget().isSpectator()) {
                    this.setTarget(null);
                    this.notTarget = null;
                }
                if ((livingEntity = this.getTarget()) instanceof Player && (plyr = (Player)livingEntity).isCreative()) {
                    this.setTarget(null);
                    this.notTarget = null;
                }
            }
            if (this.tickCount % 40 == 0) {
                // empty if block
            }
            if (this.angerTimer <= 0) {
                this.setTarget(null);
                this.notTarget = null;
                this.aggro = false;
            }
            for (Entity ent : level.getEntities((Entity)this, this.getBoundingBox())) {
                LivingEntity lEnt;
                if (!(ent instanceof LivingEntity) || !this.canTargetEntity((Entity)(lEnt = (LivingEntity)ent))) continue;
                this.notTarget = lEnt;
                this.aggro = true;
            }
            if (this.notTarget != null) {
                if (this.distanceTo((Entity)this.notTarget) < 2.0f) {
                    this.aggro = true;
                }
                if (this.notTarget.getHealth() <= 0.0f) {
                    this.notTarget = null;
                    this.setTarget(null);
                    this.aggro = false;
                }
            }
            if (this.aggro && this.notTarget != null) {
                this.setTarget(this.notTarget);
            } else {
                this.setTarget(null);
                this.aggro = false;
            }
            if (this.aggro && this.getTarget() == null) {
                this.aggro = false;
            }
        }
        super.tick();
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putBoolean("aggro", this.aggro);
        if (this.notTarget != null) {
            pCompound.putUUID("notTarget", this.notTarget.getUUID());
        }
        pCompound.putInt("eggTimer", this.eggTimer);
        pCompound.putInt("angerTimer", this.angerTimer);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("aggro")) {
            this.aggro = pCompound.getBoolean("aggro");
        }
        if (pCompound.contains("notTarget")) {
            this.notTargetUUID = pCompound.getUUID("notTarget");
        }
        this.eggTimer = pCompound.getInt("eggTimer");
        this.angerTimer = pCompound.getInt("angerTimer");
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        Entity entity;
        boolean flag = super.hurt(pSource, pAmount);
        if (!this.level().isClientSide && !this.isNoAi() && (entity = pSource.getEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.canTargetEntity(entity) && this.notTarget == null) {
                this.notTarget = living;
                this.aggro = true;
            }
        }
        return flag;
    }

    protected void customServerAiStep() {
        AttributeInstance attributeinstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if (this.getTarget() != null) {
            if (!attributeinstance.hasModifier(SPEED_MODIFIER_ATTACKING_ID)) {
                attributeinstance.addTransientModifier(SPEED_MODIFIER_ATTACKING);
            }
        } else if (attributeinstance.hasModifier(SPEED_MODIFIER_ATTACKING_ID)) {
            attributeinstance.removeModifier(SPEED_MODIFIER_ATTACKING);
        }
        super.customServerAiStep();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(2, (Goal)new LayEggInNestGoal(this, 1.0, 10));
        super.registerGoals();
    }

    protected SoundEvent getAmbientSound() {
        super.getAmbientSound();
        return (SoundEvent)NorthstarSounds.MARS_WORM_CLICK.get();
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        super.getHurtSound(pDamageSource);
        return (SoundEvent)NorthstarSounds.MARS_WORM_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        super.getDeathSound();
        return (SoundEvent)NorthstarSounds.MARS_WORM_DEATH.get();
    }

    public boolean doHurtTarget(Entity pEntity) {
        LivingEntity liv;
        boolean flag = super.doHurtTarget(pEntity);
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        this.playSound((SoundEvent)NorthstarSounds.MARS_WORM_ATTACK.get(), 1.0f, 1.0f);
        if (pEntity instanceof LivingEntity && (liv = (LivingEntity)pEntity).getHealth() <= 0.0f) {
            this.setTarget(null);
            this.aggro = false;
            this.notTarget = null;
        }
        return flag;
    }

    @Contract(value="null->false")
    public boolean canTargetEntity(@Nullable Entity ent) {
        if (ent instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)ent;
            if (this.level() == ent.level() && (ent instanceof Player || ent instanceof ZombifiedPiglin || ent instanceof MarsToadEntity)) {
                Player player;
                if (ent instanceof Player && (player = (Player)ent).isCreative()) {
                    return false;
                }
                if (ent.isSpectator()) {
                    return false;
                }
                if (this.notTarget == null) {
                    this.notTarget = livingentity;
                    this.angerTimer = 2400;
                }
                return true;
            }
        }
        return false;
    }

    private class VibrationUser
    implements VibrationSystem.User {
        private VibrationUser() {
        }

        public int getListenerRadius() {
            return 16;
        }

        @NotNull
        public PositionSource getPositionSource() {
            return new EntityPositionSource((Entity)MarsWormEntity.this, MarsWormEntity.this.getEyeHeight());
        }

        public boolean canReceiveVibration(ServerLevel level, BlockPos pos, Holder<GameEvent> event, GameEvent.Context context) {
            if (!(MarsWormEntity.this.isNoAi() || MarsWormEntity.this.isDeadOrDying() || MarsWormEntity.this.getBrain().hasMemoryValue(MemoryModuleType.VIBRATION_COOLDOWN) || !level.getWorldBorder().isWithinBounds(pos) || MarsWormEntity.this.isRemoved() || MarsWormEntity.this.level() != level)) {
                Entity entity = context.sourceEntity();
                if (entity instanceof LivingEntity) {
                    LivingEntity livingentity = (LivingEntity)entity;
                    return MarsWormEntity.this.canTargetEntity((Entity)livingentity);
                }
                return true;
            }
            return false;
        }

        public void onReceiveVibration(ServerLevel level, BlockPos pos, Holder<GameEvent> gameEvent, @Nullable Entity entity, @Nullable Entity playerEntity, float distance) {
            if (!MarsWormEntity.this.isDeadOrDying()) {
                MarsWormEntity.this.brain.setMemoryWithExpiry(MemoryModuleType.VIBRATION_COOLDOWN, (Object)Unit.INSTANCE, 40L);
                level.broadcastEntityEvent((Entity)MarsWormEntity.this, (byte)61);
                if (!MarsWormEntity.this.aggro) {
                    MarsWormEntity.this.playSound((SoundEvent)NorthstarSounds.MARS_WORM_CLICK_NOTICE.get(), 5.0f, MarsWormEntity.this.getVoicePitch());
                }
                MarsWormAi.setDisturbanceLocation(MarsWormEntity.this, pos);
                if (!(MarsWormEntity.this.notTarget == null || MarsWormEntity.this.aggro || MarsWormEntity.this.notTarget != entity && MarsWormEntity.this.notTarget != playerEntity)) {
                    MarsWormEntity.this.aggro = true;
                }
            }
        }
    }
}

