/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity;

import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MoonEelEntity
extends Monster
implements GeoAnimatable {
    private final AnimatableInstanceCache animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public MoonEelEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.getAttribute(Attributes.STEP_HEIGHT).setBaseValue(1.0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public double getTick(Object object) {
        return this.tickCount;
    }

    private PlayState predicate(AnimationState<MoonEelEntity> event) {
        if (!(event.getLimbSwingAmount() > -0.05f) || !(event.getLimbSwingAmount() < 0.05f)) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("walk"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)NorthstarSounds.MOON_EEL_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        super.getHurtSound(pDamageSource);
        return (SoundEvent)NorthstarSounds.MOON_EEL_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        super.getDeathSound();
        return (SoundEvent)NorthstarSounds.MOON_EEL_DIE.get();
    }

    public static boolean eelSpawnRules(EntityType<MoonEelEntity> eel, LevelAccessor level, MobSpawnType spawntype, BlockPos pos, RandomSource rando) {
        int surfaceY = level.getHeight(Heightmap.Types.MOTION_BLOCKING, pos.getX(), pos.getZ());
        BlockState state = level.getBlockState(pos.below());
        if (level.getEntitiesOfClass(Monster.class, new AABB(pos).inflate(92.0)).size() >= 24) {
            return false;
        }
        if (pos.getY() >= surfaceY) {
            return false;
        }
        return state.is(NorthstarTags.NorthstarBlockTags.NATURAL_MOON_BLOCKS.tag);
    }

    public boolean removeWhenFarAway(double pDistanceToClosestPlayer) {
        return false;
    }
}

