/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity;

import com.lightning.northstar.block.crops.MartianFlowerBlock;
import com.lightning.northstar.block.crops.MartianTallFlowerBlock;
import com.lightning.northstar.block.simple.VenusMushroomBlock;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.content.NorthstarItems;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class VenusVultureEntity
extends Monster
implements GeoAnimatable {
    private static final EntityDataAccessor<Byte> FLYING = SynchedEntityData.defineId(VenusVultureEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> IS_LANDING = SynchedEntityData.defineId(VenusVultureEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> IS_TAKING_OFF = SynchedEntityData.defineId(VenusVultureEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private final AnimatableInstanceCache animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @Nullable
    private BlockPos targetPosition;
    private int pollinationTimer = 0;
    private int rotationTimer = 400;
    private int flapTimer = 45;
    private float rotationModifier = 0.0f;
    private int timeForPathFinding = 400;
    private boolean pollinating = false;
    BlockPos anchorPoint = this.blockPosition();
    boolean floorOrCeiling;

    public VenusVultureEntity(EntityType<? extends VenusVultureEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public double getTick(Object object) {
        return this.tickCount;
    }

    private PlayState predicate(AnimationState<VenusVultureEntity> event) {
        if (this.flapTimer > 0 && this.isFlying()) {
            event.getController().setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().thenLoop("flap"));
        } else if (!(!this.isFlying() || event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimationSpeed(2.0).setAnimation(RawAnimation.begin().thenLoop("fly"));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimationSpeed((double)event.getLimbSwingAmount()).setAnimation(RawAnimation.begin().thenLoop("walk"));
        } else {
            event.getController().setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
    }

    public static boolean vultureSpawnRules(EntityType<VenusVultureEntity> moth, LevelAccessor level, MobSpawnType spawntype, BlockPos pos, RandomSource rando) {
        BlockState state = level.getBlockState(pos.below());
        return state.is(NorthstarTags.NorthstarBlockTags.NATURAL_VENUS_BLOCKS.tag) && level.canSeeSky(pos);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLYING, (Object)1);
        builder.define(IS_LANDING, (Object)0);
        builder.define(IS_TAKING_OFF, (Object)0);
    }

    protected SoundEvent getAmbientSound() {
        super.getAmbientSound();
        return (SoundEvent)NorthstarSounds.VENUS_VULTURE_IDLE.get();
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        return (SoundEvent)NorthstarSounds.VENUS_VULTURE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)NorthstarSounds.VENUS_VULTURE_DIE.get();
    }

    public void handleEntityEvent(byte pId) {
        super.handleEntityEvent(pId);
        if (pId == 120) {
            this.setFlying(false);
        }
        if (pId == 150) {
            this.flapTimer = 45;
        }
    }

    public void tick() {
        super.tick();
        if (this.isFlying()) {
            this.setBoundingBox(new AABB(-0.8, 0.0, -0.8, 0.8, 0.9, 0.8).move(this.getX(), this.getY(), this.getZ()));
            this.setDeltaMovement(this.getForward());
            if (this.rotationTimer > 0 && this.rotationModifier != 0.0f) {
                --this.rotationTimer;
                this.setXRot(this.getXRot() + this.rotationModifier);
                this.flapTimer = Mth.clamp((int)this.flapTimer, (int)0, (int)(this.flapTimer - 1));
                int surfaceDif = this.blockPosition().getY() - this.level().getHeight(Heightmap.Types.MOTION_BLOCKING, this.blockPosition().getX(), this.blockPosition().getZ());
                Vec3 delta = this.getDeltaMovement();
                if (this.isTakingOff() && surfaceDif < 15) {
                    this.setDeltaMovement(delta.x, delta.y + 0.9, delta.z);
                } else if (surfaceDif > 25) {
                    this.setDeltaMovement(delta.x, delta.y - 0.5, delta.z);
                } else if (surfaceDif < 15) {
                    this.setDeltaMovement(delta.x, delta.y + 0.5, delta.z);
                } else {
                    this.setTakingOff(false);
                }
                if (this.isLanding()) {
                    this.setDeltaMovement(delta.x, delta.y - 0.7, delta.z);
                    if (!this.level().getBlockState(this.blockPosition().below()).isAir()) {
                        this.level().broadcastEntityEvent((Entity)this, (byte)120);
                        this.setFlying(false);
                        this.setTakingOff(false);
                    }
                }
                if (this.level().random.nextInt(3000) == 0) {
                    this.setIsLanding(true);
                }
            } else {
                this.rotationModifier = this.level().random.nextFloat();
                this.rotationModifier = Mth.clamp((float)this.rotationModifier, (float)0.2f, (float)0.8f);
                this.flapTimer = 45;
                this.rotationModifier = this.level().random.nextBoolean() ? this.rotationModifier : this.rotationModifier * -1.0f;
                this.rotationTimer = this.level().random.nextIntBetweenInclusive(300, 1500);
            }
            for (Player player : this.level().getEntitiesOfClass(Player.class, this.getBoundingBox().inflate(15.0))) {
                if (!this.isFood(player.getItemInHand(InteractionHand.MAIN_HAND)) && !this.isFood(player.getItemInHand(InteractionHand.OFF_HAND))) continue;
                this.setIsLanding(true);
            }
        } else {
            this.setBoundingBox(new AABB(-0.4, 0.0, -0.4, 0.4, 1.8, 0.4).move(this.getX(), this.getY(), this.getZ()));
            if (this.level().random.nextInt(1000) == 0) {
                this.setFlying(true);
                this.setTakingOff(true);
                this.setIsLanding(false);
            }
        }
    }

    public InteractionResult mobInteract(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (this.isFood(itemstack)) {
            if (this.level().isClientSide) {
                return InteractionResult.CONSUME;
            }
            this.usePlayerItem(pPlayer, pHand, itemstack);
        }
        return super.mobInteract(pPlayer, pHand);
    }

    protected void usePlayerItem(Player player, InteractionHand hand, ItemStack stack) {
        if (this.isFood(stack)) {
            this.playSound(SoundEvents.CAT_EAT, 1.0f, 1.0f);
            this.targetPosition = this.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, this.blockPosition());
        }
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(((VenusMushroomBlock)((Object)NorthstarBlocks.BLOOM_FUNGUS.get())).asItem());
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        BlockPos blockpos = this.blockPosition();
        if (this.isFlying()) {
            this.fallDistance = 0.0f;
            if (!(this.targetPosition == null || this.level().isEmptyBlock(this.targetPosition) && this.targetPosition.getY() > this.level().getMinBuildHeight())) {
                this.targetPosition = null;
            }
            if (this.timeForPathFinding > 0) {
                this.timeForPathFinding = Mth.clamp((int)this.timeForPathFinding, (int)0, (int)(this.timeForPathFinding - 1));
            } else {
                this.targetPosition = null;
                this.timeForPathFinding = 400;
            }
            if (this.targetPosition == null || this.random.nextInt(30) == 0 || this.targetPosition.closerToCenterThan((Position)this.position(), 2.0) && !this.pollinating) {
                this.targetPosition = new BlockPos(this.getBlockX() + this.random.nextInt(16) - this.random.nextInt(16), this.getBlockY() + this.random.nextInt(16) - this.random.nextInt(16), this.getBlockZ() + this.random.nextInt(16) - this.random.nextInt(16));
            }
            if (this.pollinating && this.targetPosition.closerToCenterThan((Position)this.position(), 0.5)) {
                this.pollinating = false;
                this.pollinationTimer = 6000;
                if (this.level().getBlockState(this.targetPosition).getBlock() instanceof MartianFlowerBlock) {
                    item = ((MartianFlowerBlock)this.level().getBlockState(this.targetPosition).getBlock()).getSeedItem();
                    ItemEntity spawnedItem = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack((ItemLike)item, 1));
                    this.level().addFreshEntity((Entity)spawnedItem);
                } else if (this.level().getBlockState(this.targetPosition).getBlock() instanceof MartianTallFlowerBlock) {
                    item = (Item)NorthstarItems.MARS_SPROUT_SEEDS.get();
                    ItemEntity spawnedItem = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack((ItemLike)item, 1));
                    this.level().addFreshEntity((Entity)spawnedItem);
                }
                this.targetPosition = null;
            }
            if (this.targetPosition != null) {
                double tX = (double)this.targetPosition.getX() + 0.5 - this.getX();
                double tY = (double)this.targetPosition.getY() + 0.1 - this.getY();
                double tZ = (double)this.targetPosition.getZ() + 0.5 - this.getZ();
                Vec3 vec3 = this.getDeltaMovement();
                Vec3 vec31 = vec3.add((Math.signum(tX) * 0.5 - vec3.x) * (double)0.1f, (Math.signum(tY) * (double)0.7f - vec3.y) * (double)0.1f, (Math.signum(tZ) * 0.5 - vec3.z) * (double)0.1f);
                this.setDeltaMovement(vec31);
                float f = (float)(Mth.atan2((double)vec31.z, (double)vec31.x) * 57.2957763671875) - 90.0f;
                float f1 = Mth.wrapDegrees((float)(f - this.getYRot()));
                this.zza = 0.5f;
                this.setYRot(this.getYRot() + f1);
                if (this.random.nextInt(300) == 0 && this.level().getBlockState(blockpos.below()).isRedstoneConductor((BlockGetter)this.level(), blockpos.below()) && !this.pollinating) {
                    this.setFlying(false);
                }
            }
        } else if (this.random.nextInt(500) == 0) {
            this.setFlying(true);
        }
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putBoolean("flying", this.isFlying());
        pCompound.putBoolean("pollinating", this.pollinating);
        pCompound.putInt("pollinationTimer", this.pollinationTimer);
        pCompound.putInt("timeForPathFinding", this.timeForPathFinding);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("flying")) {
            this.setFlying(pCompound.getBoolean("flying"));
        }
        if (pCompound.contains("pollinating")) {
            this.pollinating = pCompound.getBoolean("pollinating");
        }
        if (pCompound.contains("pollinationTimer")) {
            this.pollinationTimer = pCompound.getInt("pollinationTimer");
        }
        if (pCompound.contains("timeForPathFinding")) {
            this.timeForPathFinding = pCompound.getInt("timeForPathFinding");
        }
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.isInvulnerableTo(pSource)) {
            return false;
        }
        if (!this.level().isClientSide && !this.isFlying()) {
            this.setFlying(true);
            this.setTakingOff(true);
            this.setIsLanding(false);
        }
        return super.hurt(pSource, pAmount);
    }

    public boolean isFlying() {
        return ((Byte)this.entityData.get(FLYING) & 1) != 0;
    }

    public void setFlying(boolean flying) {
        if (flying) {
            this.entityData.set(FLYING, (Object)1);
            this.rotationModifier = this.level().random.nextFloat();
            this.rotationModifier = Mth.clamp((float)this.rotationModifier, (float)0.2f, (float)0.8f);
            this.flapTimer = 45;
            this.rotationModifier = this.level().random.nextBoolean() ? this.rotationModifier : this.rotationModifier * -1.0f;
            this.level().broadcastEntityEvent((Entity)this, (byte)-106);
        } else {
            this.entityData.set(FLYING, (Object)-2);
        }
    }

    public boolean isTakingOff() {
        return ((Byte)this.entityData.get(IS_TAKING_OFF) & 1) != 0;
    }

    public boolean isLanding() {
        return ((Byte)this.entityData.get(IS_LANDING) & 1) != 0;
    }

    public void setIsLanding(boolean flying) {
        if (flying) {
            this.entityData.set(IS_LANDING, (Object)1);
        } else {
            this.entityData.set(IS_LANDING, (Object)-2);
        }
    }

    public void setTakingOff(boolean flying) {
        if (flying) {
            this.entityData.set(IS_TAKING_OFF, (Object)1);
        } else {
            this.entityData.set(IS_TAKING_OFF, (Object)-2);
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of((ItemLike[])new ItemLike[]{((VenusMushroomBlock)((Object)NorthstarBlocks.BLOOM_FUNGUS.get())).asItem()}), false));
        super.registerGoals();
    }

    public boolean doHurtTarget(Entity pEntity) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        this.playSound(SoundEvents.RAVAGER_ATTACK, 1.0f, 1.0f);
        return super.doHurtTarget(pEntity);
    }

    public AgeableMob getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }
}

