/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity.goals;

import com.lightning.northstar.block.simple.MarsWormNestBlock;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.entity.MarsWormEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.neoforged.neoforge.event.EventHooks;

public class LayEggInNestGoal
extends MoveToBlockGoal {
    private final Block blockToRemove = (Block)NorthstarBlocks.MARS_WORM_NEST.get();
    private final MarsWormEntity removerMob;
    private BlockPos pos;
    private int ticksSinceReachedGoal;
    private static final int WAIT_AFTER_BLOCK_FOUND = 20;

    public LayEggInNestGoal(MarsWormEntity pRemoverMob, double pSpeedModifier, int pSearchRange) {
        super((PathfinderMob)pRemoverMob, pSpeedModifier, 24, pSearchRange);
        this.removerMob = pRemoverMob;
    }

    public double acceptedDistance() {
        return 2.0;
    }

    public boolean canUse() {
        if (!EventHooks.canEntityGrief((Level)this.removerMob.level(), (Entity)this.removerMob)) {
            return false;
        }
        if (this.removerMob.eggTimer > 0) {
            return false;
        }
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        if (this.tryFindBlock()) {
            this.nextStartTick = LayEggInNestGoal.reducedTickDelay((int)20);
            return true;
        }
        this.nextStartTick = this.nextStartTick(this.mob);
        return false;
    }

    private boolean tryFindBlock() {
        return this.blockPos != null && this.isValidTarget((LevelReader)this.mob.level(), this.blockPos) ? true : this.findNearestBlock();
    }

    public void stop() {
        super.stop();
        this.removerMob.fallDistance = 1.0f;
    }

    public void start() {
        super.start();
        this.ticksSinceReachedGoal = 0;
    }

    public void playDestroyProgressSound(LevelAccessor pLevel, BlockPos pPos) {
    }

    public void playBreakSound(Level pLevel, BlockPos pPos) {
    }

    public void tick() {
        super.tick();
        Level level = this.removerMob.level();
        BlockState state = level.getBlockState(this.pos);
        if (this.removerMob.eggTimer != 0) {
            this.stop();
        }
        if (state.is(this.blockToRemove)) {
            if (((Boolean)state.getValue((Property)MarsWormNestBlock.HAS_EGG)).booleanValue()) {
                this.stop();
            }
        } else {
            this.stop();
        }
        if (this.isReachedTarget() && this.removerMob.eggTimer == 0) {
            if (level.getBlockState(this.pos).is((Block)NorthstarBlocks.MARS_WORM_NEST.get())) {
                level.setBlockAndUpdate(this.pos, (BlockState)level.getBlockState(this.pos).setValue((Property)MarsWormNestBlock.HAS_EGG, (Comparable)Boolean.valueOf(true)));
                level.playSound(null, this.pos, SoundEvents.FROG_LAY_SPAWN, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            this.removerMob.eggTimer = 6000;
            ++this.ticksSinceReachedGoal;
        }
    }

    protected boolean isValidTarget(LevelReader pLevel, BlockPos pPos) {
        boolean flag;
        ChunkAccess chunkaccess = pLevel.getChunk(SectionPos.blockToSectionCoord((int)pPos.getX()), SectionPos.blockToSectionCoord((int)pPos.getZ()), ChunkStatus.FULL, false);
        if (chunkaccess == null) {
            return false;
        }
        if (!chunkaccess.getBlockState(pPos).canEntityDestroy((BlockGetter)pLevel, pPos, (Entity)this.removerMob)) {
            return false;
        }
        boolean bl = flag = chunkaccess.getBlockState(pPos).is(this.blockToRemove) && chunkaccess.getBlockState(pPos.above()).isAir() && chunkaccess.getBlockState(pPos.above(2)).isAir();
        if (flag) {
            if (!((Boolean)chunkaccess.getBlockState(pPos).getValue((Property)MarsWormNestBlock.HAS_EGG)).booleanValue()) {
                this.pos = pPos;
            } else {
                flag = false;
            }
        }
        return flag;
    }
}

