/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity.projectiles.renderers;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.entity.projectiles.LunargradeSpit;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.LlamaSpitModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LunargradeSpitRenderer
extends EntityRenderer<LunargradeSpit> {
    private static final ResourceLocation LLAMA_SPIT_LOCATION = Northstar.asResource("textures/entity/llama/spit.png");
    private final LlamaSpitModel<LunargradeSpit> model;

    public LunargradeSpitRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new LlamaSpitModel(pContext.bakeLayer(ModelLayers.LLAMA_SPIT));
    }

    public void render(LunargradeSpit pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.pushPose();
        pMatrixStack.translate(0.0, (double)0.15f, 0.0);
        pMatrixStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)pPartialTicks, (float)pEntity.yRotO, (float)pEntity.getYRot()) - 90.0f));
        pMatrixStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)pPartialTicks, (float)pEntity.xRotO, (float)pEntity.getXRot())));
        this.model.setupAnim((Entity)pEntity, pPartialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = pBuffer.getBuffer(this.model.renderType(LLAMA_SPIT_LOCATION));
        this.model.renderToBuffer(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY);
        pMatrixStack.popPose();
        super.render((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(LunargradeSpit pEntity) {
        return LLAMA_SPIT_LOCATION;
    }
}

