/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin;

import com.lightning.northstar.contraption.rocket.RocketHandler;
import com.lightning.northstar.world.dimension.NorthstarDimensions;
import com.lightning.northstar.world.dimension.NorthstarPlanets;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class GravityStuffMixin {
    @Unique
    private static final double CONSTANT = 0.08;
    private static final double EARTH_GRAV = 1.0;
    private static final double MOON_GRAV = 0.16;
    private static final double OUTER_MOON_GRAV = 0.06;
    private static final double SUPER_GRAV = 4.0;
    private static final double MARS_GRAV = 0.37;
    private static final double VENUS_GRAV = 0.89;
    private static final double MERCURY_GRAV = 0.38;
    private static final double GANYMEDE_GRAV = 0.14;
    private static final double TITAN_GRAV = 0.14;
    private static final double EUROPA_GRAV = 0.13;
    double PLANET_GRAV = 1.0;
    private int fall_disabled = 0;

    @Inject(method={"travel(Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="TAIL")})
    public void northstar$travel(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (this.fall_disabled > 0) {
            --this.fall_disabled;
            entity.fallDistance = 0.0f;
        }
        if (RocketHandler.isInRocket((Entity)entity) && entity.getY() > 1500.0) {
            this.fall_disabled = 400;
        }
        Vec3 velocity = entity.getDeltaMovement();
        boolean isInOrbit = NorthstarPlanets.isInOrbit((ResourceKey<Level>)entity.level().dimension());
        this.PLANET_GRAV = entity.level().dimension() == NorthstarDimensions.MARS_DIM_KEY ? 0.37 : (entity.level().dimension() == NorthstarDimensions.VENUS_DIM_KEY ? 0.89 : (entity.level().dimension() == NorthstarDimensions.MOON_DIM_KEY ? 0.16 : (entity.level().dimension() == NorthstarDimensions.MERCURY_DIM_KEY ? 0.38 : (isInOrbit ? 0.06 : 1.0))));
        if (entity.isFallFlying() || entity.isInFluidType()) {
            this.PLANET_GRAV = 1.0;
        }
        if (!(entity.isNoGravity() || entity.isInWater() || entity.isInLava() || entity.hasEffect(MobEffects.SLOW_FALLING))) {
            Player ply;
            float dust_push = 0.0f;
            if (entity.level().getRainLevel(0.0f) > 0.0f && entity.level().getRawBrightness(entity.blockPosition(), -1) == 16 && !entity.isSpectator() && entity.level().dimension() == NorthstarDimensions.MARS_DIM_KEY && entity.level().isInWorldBounds(entity.blockPosition()) && !RocketHandler.isInRocket((Entity)entity)) {
                dust_push = 0.005f;
            }
            if (entity instanceof Player && (ply = (Player)entity).isCreative()) {
                dust_push = 0.0f;
            }
            double newGrav = 0.08 * this.PLANET_GRAV;
            float crouchPush = 0.0f;
            if (!isInOrbit) {
                entity.setDeltaMovement(velocity.x() + (double)dust_push, velocity.y() + (0.08 - newGrav), velocity.z() - (double)dust_push);
            } else {
                if (entity.isCrouching()) {
                    crouchPush = 0.05f;
                }
                float vel_y = (float)Mth.clamp((double)velocity.y(), (double)-0.3, (double)15.0);
                entity.setDeltaMovement(velocity.x() + (double)dust_push, (double)vel_y + (0.08 - newGrav) - (double)crouchPush, velocity.z() - (double)dust_push);
            }
        }
    }

    @Inject(method={"calculateFallDamage(FF)I"}, at={@At(value="HEAD")}, cancellable=true)
    public void calculateFallDamage(float pFallDistance, float pDamageMultiplier, CallbackInfoReturnable<Integer> info) {
        LivingEntity entity = (LivingEntity)this;
        if (!NorthstarPlanets.hasNormalGrav((ResourceKey<Level>)entity.level().dimension())) {
            MobEffectInstance mobeffectinstance = entity.getEffect(MobEffects.JUMP);
            double mult = this.getGravMultiplier((ResourceKey<Level>)entity.level().dimension());
            float f = (float)(mobeffectinstance == null ? 0.0 : (double)(mobeffectinstance.getAmplifier() + 1) * mult);
            info.setReturnValue((Object)Mth.ceil((double)(((double)pFallDistance * mult - 3.0 - (double)f) * (double)pDamageMultiplier)));
        }
    }

    public double getGravMultiplier(ResourceKey<Level> level) {
        if (level == NorthstarDimensions.MOON_DIM_KEY) {
            return 0.16;
        }
        if (level == NorthstarDimensions.MARS_DIM_KEY) {
            return 0.37;
        }
        if (level == NorthstarDimensions.MERCURY_DIM_KEY) {
            return 0.38;
        }
        if (level == NorthstarDimensions.VENUS_DIM_KEY) {
            return 0.89;
        }
        if (level == NorthstarDimensions.EARTH_ORBIT_DIM_KEY) {
            return 0.06;
        }
        return 1.0;
    }
}

