/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin;

import com.lightning.northstar.world.dimension.NorthstarDimensions;
import com.lightning.northstar.world.dimension.NorthstarPlanets;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin {
    @Shadow
    protected abstract BlockPos findLightningTargetAround(BlockPos var1);

    @Inject(method={"tickChunk(Lnet/minecraft/world/level/chunk/LevelChunk;I)V"}, at={@At(value="HEAD")})
    public void tickChunk(LevelChunk pChunk, int pRandomTickSpeed, CallbackInfo info) {
        ServerLevel level = (ServerLevel)this;
        if (level != null && level.dimension() == NorthstarDimensions.VENUS_DIM_KEY) {
            ChunkPos chunkpos = pChunk.getPos();
            boolean flag = level.isRaining();
            int i = chunkpos.getMinBlockX();
            int j = chunkpos.getMinBlockZ();
            ProfilerFiller profilerfiller = level.getProfiler();
            profilerfiller.push("thunder");
            if (flag && level.random.nextInt(15000) == 0) {
                BlockPos blockpos = this.findLightningTargetAround(level.getBlockRandomPos(i, 0, j, 15));
                LightningBolt lightningbolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)level);
                lightningbolt.moveTo(Vec3.atBottomCenterOf((Vec3i)blockpos));
                level.addFreshEntity((Entity)lightningbolt);
            }
            profilerfiller.pop();
        }
    }

    @Inject(method={"getSeed()J"}, at={@At(value="HEAD")}, cancellable=true)
    public void getSeed(CallbackInfoReturnable<Long> info) {
        ServerLevel level = (ServerLevel)this;
        if (level != null) {
            long seed = level.getServer().getWorldData().worldGenOptions().seed();
            info.setReturnValue((Object)(seed + NorthstarPlanets.getSeedOffset((ResourceKey<Level>)level.dimension())));
        }
    }
}

