/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin.block;

import com.lightning.northstar.world.NorthstarTemperature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FluidState.class})
public class FluidStateMixin {
    @Inject(method={"tick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V"}, at={@At(value="TAIL")})
    public void northstar$tick(Level pLevel, BlockPos pPos, CallbackInfo info) {
        FluidState state = pLevel.getFluidState(pPos);
        BlockState block = pLevel.getBlockState(pPos);
        float temp = NorthstarTemperature.getTemperatureAt(pLevel, (Vec3i)pPos);
        if (temp > (float)NorthstarTemperature.getBoilingPoint(state)) {
            if (block.hasProperty((Property)BlockStateProperties.WATERLOGGED) && !state.isEmpty()) {
                pLevel.setBlockAndUpdate(pPos, (BlockState)block.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
                this.removeFluid(pLevel, pPos, state);
            } else {
                pLevel.setBlock(pPos, Blocks.AIR.defaultBlockState(), 3);
                this.removeFluid(pLevel, pPos, state);
            }
        }
        if (temp < (float)NorthstarTemperature.getFreezingPoint(state) && state.is((Fluid)Fluids.WATER)) {
            if (block.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                pLevel.setBlockAndUpdate(pPos, (BlockState)block.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
                this.removeFluid(pLevel, pPos, state);
            } else {
                pLevel.setBlockAndUpdate(pPos, Blocks.ICE.defaultBlockState());
            }
        }
        if (NorthstarTemperature.isCombustible(state) && (float)NorthstarTemperature.combustionTemp(state) <= temp) {
            this.combust(pLevel, pPos, state);
        }
    }

    public void removeFluid(Level level, BlockPos pos, FluidState fluid) {
        for (Direction dir : Direction.values()) {
            BlockPos.MutableBlockPos newpos = pos.mutable().move(dir);
            if (level.getFluidState((BlockPos)newpos).is(fluid.getType()) && level.getBlockState((BlockPos)newpos).canBeReplaced(fluid.getType()) && !level.getBlockState((BlockPos)newpos).hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                level.setBlock((BlockPos)newpos, Blocks.AIR.defaultBlockState(), 3);
                continue;
            }
            if (!level.getBlockState((BlockPos)newpos).hasProperty((Property)BlockStateProperties.WATERLOGGED) || !fluid.is((Fluid)Fluids.WATER)) continue;
            level.setBlockAndUpdate((BlockPos)newpos, (BlockState)level.getBlockState((BlockPos)newpos).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void combust(Level level, BlockPos pos, FluidState fluid) {
        level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        level.explode(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 2.5f, true, Level.ExplosionInteraction.MOB);
    }
}

