/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin.block;

import com.lightning.northstar.particle.ColdAirParticleData;
import com.lightning.northstar.world.NorthstarTemperature;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={IceBlock.class})
public class IceBlockMixin {
    @Inject(method={"randomTick(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V"}, at={@At(value="TAIL")})
    public void northstar$randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random, CallbackInfo info) {
        if (!state.is(Blocks.ICE)) {
            return;
        }
        float temperature = this.northstar$getHighestTemperatureAround(level, pos);
        if ((double)random.nextFloat() > 0.4) {
            if (100.0f < temperature) {
                this.northstar$evaporate((Level)level, pos);
            } else if (32.0f < temperature) {
                this.northstar$melt((Level)level, pos);
            }
        } else if (32.0f < temperature) {
            this.northstar$coldAirParticles((Level)level, pos, random);
        }
    }

    @Unique
    public float northstar$getHighestTemperatureAround(ServerLevel level, BlockPos pos) {
        float temperature = Float.NEGATIVE_INFINITY;
        for (Direction direction : Iterate.directions) {
            float temp = NorthstarTemperature.getTemperatureAt((Level)level, (Vec3i)pos.relative(direction));
            if (!(temp > temperature)) continue;
            temperature = temp;
        }
        return temperature;
    }

    @Unique
    public void northstar$coldAirParticles(Level level, BlockPos pos, RandomSource random) {
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        for (Direction dir : Direction.values()) {
            if (!level.getBlockState(pos.relative(dir)).isAir() || random.nextInt(20) != 0) continue;
            double d0 = (double)x + (double)(dir.getStepX() / 2) + random.nextDouble();
            double d1 = (double)y + 0.7;
            double d2 = (double)z + (double)(dir.getStepZ() / 2) + random.nextDouble();
            level.addParticle((ParticleOptions)new ColdAirParticleData(), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Unique
    protected void northstar$melt(Level pLevel, BlockPos pPos) {
        pLevel.setBlockAndUpdate(pPos, Fluids.WATER.getFluidType().getBlockForFluidState((BlockAndTintGetter)pLevel, pPos, Fluids.WATER.defaultFluidState()));
        pLevel.neighborChanged(pPos, Fluids.WATER.getFluidType().getBlockForFluidState((BlockAndTintGetter)pLevel, pPos, Fluids.WATER.defaultFluidState()).getBlock(), pPos);
    }

    @Unique
    protected void northstar$evaporate(Level level, BlockPos pos) {
        level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        level.neighborChanged(pos, Blocks.AIR, pos);
        int i = pos.getX();
        int j = pos.getY();
        int k = pos.getZ();
        level.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
        }
    }
}

