/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin.gravitystuff;

import com.lightning.northstar.world.dimension.NorthstarDimensions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrow.class})
public class AbstractArrowGravityMixin {
    @Unique
    private static final double CONSTANT = 0.08;
    private static final double EARTH_GRAV = 1.0;
    private static final double VENUS_GRAV = 0.92;
    private static final double MOON_GRAV = 0.5;
    private static final double MARS_GRAV = 0.5;
    private static final double MERCURY_GRAV = 0.5;
    private static final double ORBIT_GRAV = 0.5;
    double PLANET_GRAV = 1.0;

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    public void northstar$tick(CallbackInfo ci) {
        Entity entity = (Entity)this;
        Vec3 velocity = entity.getDeltaMovement();
        this.PLANET_GRAV = entity.level().dimension() == NorthstarDimensions.MARS_DIM_KEY ? 0.5 : (entity.level().dimension() == NorthstarDimensions.MOON_DIM_KEY ? 0.5 : (entity.level().dimension() == NorthstarDimensions.VENUS_DIM_KEY ? 0.92 : (entity.level().dimension() == NorthstarDimensions.MERCURY_DIM_KEY ? 0.5 : (entity.level().dimension() == NorthstarDimensions.EARTH_ORBIT_DIM_KEY ? 0.5 : 1.0))));
        if (!entity.isNoGravity()) {
            double newGrav = 0.08 * this.PLANET_GRAV;
            entity.setDeltaMovement(velocity.x(), velocity.y() + 0.08 - newGrav, velocity.z());
        }
    }
}

