/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.particle;

import com.lightning.northstar.particle.ColdAirParticleData;
import com.lightning.northstar.particle.DustCloudParticleData;
import com.lightning.northstar.particle.GlowstoneParticleData;
import com.lightning.northstar.particle.OxyFlowParticleData;
import com.lightning.northstar.particle.RocketFlameLandingParticleData;
import com.lightning.northstar.particle.RocketFlameParticleData;
import com.lightning.northstar.particle.RocketSmokeLandingParticleData;
import com.lightning.northstar.particle.RocketSmokeParticleData;
import com.lightning.northstar.particle.SnailSlimeParticleData;
import com.lightning.northstar.particle.SnowflakeParticleData;
import com.lightning.northstar.particle.SulfurPoofParticleData;
import com.simibubi.create.foundation.particle.ICustomParticleData;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public enum NorthstarParticles {
    GLOWSTONE_PARTICLE(GlowstoneParticleData::new),
    ROCKET_FLAME(RocketFlameParticleData::new),
    ROCKET_FLAME_LANDING(RocketFlameLandingParticleData::new),
    ROCKET_SMOKE(RocketSmokeParticleData::new),
    ROCKET_SMOKE_LANDING(RocketSmokeLandingParticleData::new),
    COLD_AIR(ColdAirParticleData::new),
    OXY_FLOW(OxyFlowParticleData::new),
    SNOWFLAKE(SnowflakeParticleData::new),
    SNAIL_SLIME(SnailSlimeParticleData::new),
    SULFUR_POOF(SulfurPoofParticleData::new),
    DUST_CLOUD(DustCloudParticleData::new);

    private final ParticleEntry<?> entry;

    private <D extends ParticleOptions> NorthstarParticles(Supplier<? extends ICustomParticleData<D>> typeFactory) {
        this.entry = new ParticleEntry(this.name().toLowerCase(Locale.ROOT), typeFactory);
    }

    public static void register(IEventBus modEventBus) {
        ParticleEntry.REGISTER.register(modEventBus);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerFactories(RegisterParticleProvidersEvent event) {
        for (NorthstarParticles particle : NorthstarParticles.values()) {
            particle.entry.registerFactory(event);
        }
    }

    public ParticleType<?> get() {
        return (ParticleType)this.entry.object.get();
    }

    public String parameter() {
        return this.entry.name;
    }

    private static class ParticleEntry<D extends ParticleOptions> {
        private static final DeferredRegister<ParticleType<?>> REGISTER = DeferredRegister.create((ResourceKey)Registries.PARTICLE_TYPE, (String)"northstar");
        private final String name;
        private final Supplier<? extends ICustomParticleData<D>> typeFactory;
        private final DeferredHolder<ParticleType<?>, ParticleType<D>> object;

        public ParticleEntry(String name, Supplier<? extends ICustomParticleData<D>> typeFactory) {
            this.name = name;
            this.typeFactory = typeFactory;
            this.object = REGISTER.register(name, () -> this.typeFactory.get().createType());
        }

        @OnlyIn(value=Dist.CLIENT)
        public void registerFactory(RegisterParticleProvidersEvent event) {
            this.typeFactory.get().register((ParticleType)this.object.get(), event);
        }
    }
}

