/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.particle;

import com.lightning.northstar.particle.NorthstarParticles;
import com.lightning.northstar.particle.RocketFlameParticleData;
import com.simibubi.create.content.equipment.bell.BasicParticleData;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;

public class RocketFlameParticle
extends SimpleAnimatedParticle {
    protected RocketFlameParticle(ClientLevel world, double x, double y, double z, double pXSpeed, double pYSpeed, double pZSpeed, SpriteSet sprite) {
        super(world, x, y, z, sprite, world.random.nextFloat() * 1.2f);
        this.quadSize *= 0.8f;
        this.lifetime = 18;
        this.scale(15.0f);
        this.setSize(6.0f, 6.0f);
        double x_off = (double)(this.random.nextInt(2) * (this.random.nextBoolean() ? -1 : 1)) * 0.01;
        double z_off = (double)(this.random.nextInt(2) * (this.random.nextBoolean() ? -1 : 1)) * 0.01;
        this.xd += x_off;
        this.yd += 0.02;
        this.zd += z_off;
        this.hasPhysics = true;
        this.selectSprite(7);
        Vec3 offset = VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)world.random, (float)0.15f);
        this.setPos(x + offset.x, y + offset.y - 0.3, z + offset.z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.setAlpha(0.6f);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    private void selectSprite(int index) {
        this.setSprite(this.sprites.get(index, 8));
    }

    public float getQuadSize(float pScaleFactor) {
        float f = ((float)this.age + pScaleFactor) / (float)this.lifetime;
        return this.quadSize * (1.0f - f * f * 0.5f);
    }

    public int getLightColor(float pPartialTick) {
        float f = ((float)this.age + pPartialTick) / (float)this.lifetime;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        int i = super.getLightColor(pPartialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public static class Data
    extends BasicParticleData<RocketFlameParticle> {
        public BasicParticleData.IBasicParticleFactory<RocketFlameParticle> getBasicFactory() {
            return RocketFlameParticle::new;
        }

        public ParticleType<?> getType() {
            return NorthstarParticles.ROCKET_FLAME.get();
        }
    }

    public static class Factory
    implements ParticleProvider<RocketFlameParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet animatedSprite) {
            this.spriteSet = animatedSprite;
        }

        public Particle createParticle(RocketFlameParticleData data, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new RocketFlameParticle(worldIn, x, y, z, zSpeed, zSpeed, zSpeed, this.spriteSet);
        }
    }
}

