/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.util;

import net.minecraft.core.Vec3i;

public class MutableAABB {
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;

    public MutableAABB() {
    }

    public MutableAABB(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public void zero() {
        this.minX = 0;
        this.minY = 0;
        this.minZ = 0;
        this.maxX = 0;
        this.maxY = 0;
        this.maxZ = 0;
    }

    public void neg() {
        this.minZ = Integer.MAX_VALUE;
        this.minY = Integer.MAX_VALUE;
        this.minX = Integer.MAX_VALUE;
        this.maxZ = Integer.MIN_VALUE;
        this.maxY = Integer.MIN_VALUE;
        this.maxX = Integer.MIN_VALUE;
    }

    public void inf() {
        this.minZ = Integer.MIN_VALUE;
        this.minY = Integer.MIN_VALUE;
        this.minX = Integer.MIN_VALUE;
        this.maxZ = Integer.MAX_VALUE;
        this.maxY = Integer.MAX_VALUE;
        this.maxX = Integer.MAX_VALUE;
    }

    public void union(Vec3i vec) {
        this.union(vec.getX(), vec.getY(), vec.getZ());
    }

    public void union(int x, int y, int z) {
        if (x < this.minX) {
            this.minX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        }
        if (z < this.minZ) {
            this.minZ = z;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
        if (z > this.maxZ) {
            this.maxZ = z;
        }
    }

    public void set(MutableAABB other) {
        this.minX = other.minX;
        this.minY = other.minY;
        this.minZ = other.minZ;
        this.maxX = other.maxX;
        this.maxY = other.maxY;
        this.maxZ = other.maxZ;
    }

    public boolean contains(Vec3i pos) {
        return this.contains(pos.getX(), pos.getY(), pos.getZ());
    }

    public boolean contains(int x, int y, int z) {
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY && z >= this.minZ && z <= this.maxZ;
    }

    public void setCentered(int cx, int cy, int cz, int sx, int sy, int sz) {
        this.minX = cx - sx;
        this.minY = cy - sy;
        this.minZ = cz - sz;
        this.maxX = cx + sx;
        this.maxY = cy + sy;
        this.maxZ = cz + sz;
    }

    public int width() {
        return this.maxX - this.minX;
    }

    public int height() {
        return this.maxY - this.minY;
    }

    public int depth() {
        return this.maxZ - this.minZ;
    }
}

