/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.util;

import com.lightning.northstar.block.simple.GrateBlock;
import com.lightning.northstar.block.simple.VerticalSlabBlock;
import com.lightning.northstar.block.simple.VerticalSlabType;
import com.lightning.northstar.data.Tags;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class NorthstarDataGenHelper {
    public static <I extends BlockItem> NonNullBiConsumer<DataGenContext<Item, I>, RegistrateItemModelProvider> itemGeneratedItem() {
        return (c, p) -> p.generated(() -> ((DataGenContext)c).get(), new ResourceLocation[]{p.modLoc("item/" + c.getName())});
    }

    public static <I extends BlockItem> NonNullBiConsumer<DataGenContext<Item, I>, RegistrateItemModelProvider> itemGeneratedBlock(String ... suffix) {
        return (c, p) -> p.generated(() -> ((DataGenContext)c).get(), new ResourceLocation[]{p.modLoc("block/" + c.getName() + String.join((CharSequence)"", suffix))});
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> manualModel() {
        return (c, p) -> {};
    }

    public static NonNullBiConsumer<DataGenContext<Block, SlabBlock>, RegistrateBlockstateProvider> simpleSlab() {
        return (c, p) -> {};
    }

    public static NonNullBiConsumer<DataGenContext<Block, VerticalSlabBlock>, RegistrateBlockstateProvider> simpleVerticalSlab() {
        return (c, p) -> {};
    }

    public static NonNullBiConsumer<RegistrateBlockLootTables, VerticalSlabBlock> verticalSlabLoot() {
        return (c, b) -> c.add((Block)b, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)c.applyExplosionDecay((ItemLike)b, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)b).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)b).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(VerticalSlabBlock.TYPE, (Comparable)((Object)VerticalSlabType.DOUBLE)))))))));
    }

    public static <B extends Block> NonNullBiConsumer<RegistrateBlockLootTables, B> cropLoot(ItemLike result, ItemLike seeds, int maxAge) {
        return (c, b) -> {
            LootItemBlockStatePropertyCondition.Builder condition = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)b).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CropBlock.AGE, maxAge));
            c.add(b, c.createCropDrops(b, result.asItem(), seeds.asItem(), (LootItemCondition.Builder)condition));
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateRecipeProvider> plankRecipe(Tags.Tag<Item> log) {
        return NorthstarDataGenHelper.plankRecipe(log.tag());
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateRecipeProvider> plankRecipe(TagKey<Item> log) {
        return (c, p) -> RegistrateRecipeProvider.planksFromLog((RecipeOutput)p, (ItemLike)((ItemLike)c.get()), (TagKey)log, (int)4);
    }

    public static NonNullBiConsumer<DataGenContext<Block, SlabBlock>, RegistrateRecipeProvider> slabRecipe(BlockEntry<Block> source) {
        return (c, p) -> {
            RegistrateRecipeProvider.slab((RecipeOutput)p, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, () -> ((SlabBlock)c.get()).asItem(), () -> ((Block)source.get()).asItem());
            p.stonecutting(DataIngredient.items((ItemLike)((Block)source.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 2);
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, VerticalSlabBlock>, RegistrateRecipeProvider> verticalSlabRecipe(BlockEntry<Block> source) {
        return (c, p) -> {
            Item material = ((Block)source.get()).asItem();
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)c.get()), (int)6).define(Character.valueOf('#'), (ItemLike)material).pattern("#").pattern("#").pattern("#").unlockedBy(RegistrateRecipeProvider.getHasName((ItemLike)material), RegistrateRecipeProvider.has((ItemLike)material)).save((RecipeOutput)p);
            p.stonecutting(DataIngredient.items((ItemLike)((Block)source.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 2);
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, StairBlock>, RegistrateRecipeProvider> stairRecipe(BlockEntry<Block> source) {
        return (c, p) -> {
            Item material = ((Block)source.get()).asItem();
            RegistrateRecipeProvider.stairBuilder(() -> ((StairBlock)c.get()).asItem(), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{material})).unlockedBy(RegistrateRecipeProvider.getHasName((ItemLike)material), RegistrateRecipeProvider.has((ItemLike)material)).save((RecipeOutput)p);
            p.stonecutting(DataIngredient.items((ItemLike)((Block)source.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 1);
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, WallBlock>, RegistrateRecipeProvider> wallRecipe(BlockEntry<Block> source) {
        return (c, p) -> {
            RegistrateRecipeProvider.wall((RecipeOutput)p, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, () -> ((WallBlock)c.get()).asItem(), () -> ((Block)source.get()).asItem());
            p.stonecutting(DataIngredient.items((ItemLike)((Block)source.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 1);
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateRecipeProvider> sheetmetalRecipe(Tags.Tag<Item> sheet) {
        return NorthstarDataGenHelper.sheetmetalRecipe(sheet.tag());
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateRecipeProvider> sheetmetalRecipe(TagKey<Item> sheet) {
        return NorthstarDataGenHelper.commonFourToFourRecipe(sheet);
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateRecipeProvider> platingRecipe(Tags.Tag<Item> ingot) {
        return NorthstarDataGenHelper.platingRecipe(ingot.tag());
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateRecipeProvider> platingRecipe(TagKey<Item> sheet) {
        return NorthstarDataGenHelper.commonFourToFourRecipe(sheet);
    }

    public static <B extends Block> NonNullBiConsumer<DataGenContext<Block, B>, RegistrateRecipeProvider> commonFourToFourRecipe(TagKey<Item> tag) {
        return (c, p) -> {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)c.get()), (int)4).unlockedBy("has_item", RegistrateRecipeProvider.has((TagKey)tag)).define(Character.valueOf('#'), tag).pattern("##").pattern("##").save((RecipeOutput)p);
            p.stonecutting(DataIngredient.tag((TagKey)tag), RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 1);
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, RotatedPillarBlock>, RegistrateRecipeProvider> pillarRecipe(Tags.Tag<Item> material) {
        return NorthstarDataGenHelper.pillarRecipe(material.tag());
    }

    public static NonNullBiConsumer<DataGenContext<Block, RotatedPillarBlock>, RegistrateRecipeProvider> pillarRecipe(TagKey<Item> material) {
        return (c, p) -> {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)c.get()), (int)2).unlockedBy("has_item", RegistrateRecipeProvider.has((TagKey)material)).define(Character.valueOf('#'), material).pattern("#").pattern("#").save((RecipeOutput)p);
            p.stonecutting(DataIngredient.tag((TagKey)material), RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 1);
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, RotatedPillarBlock>, RegistrateRecipeProvider> pillarRecipe(ItemLike material) {
        return (c, p) -> {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)c.get()), (int)2).unlockedBy("has_item", RegistrateRecipeProvider.has((ItemLike)material)).define(Character.valueOf('#'), material).pattern("#").pattern("#").save((RecipeOutput)p);
            p.stonecutting(DataIngredient.items((ItemLike)material, (ItemLike[])new ItemLike[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)c, 1);
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, Block>, RegistrateRecipeProvider> chiseledRecipe(ItemLike slab) {
        return (c, p) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)c.get()), (int)1).unlockedBy("has_item", RegistrateRecipeProvider.has((ItemLike)slab)).define(Character.valueOf('#'), slab).pattern("#").pattern("#").save((RecipeOutput)p);
    }

    public static NonNullBiConsumer<DataGenContext<Block, GrateBlock>, RegistrateRecipeProvider> grateRecipe(Tags.Tag<Item> material) {
        return (c, p) -> ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)c.get()), (int)5).unlockedBy("has_item", RegistrateRecipeProvider.has(material.tag())).define(Character.valueOf('#'), material.tag()).pattern("# #").pattern(" # ").pattern("# #").save((RecipeOutput)p);
    }
}

