/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.dimension;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.world.dimension.NorthstarDimensions;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber(modid="northstar")
public class NorthstarPlanets {
    private static final double EARTH_GRAV = 1.0;
    private static final double MOON_GRAV = 0.16;
    private static final double OUTER_MOON_GRAV = 0.06;
    private static final double SUPER_GRAV = 4.0;
    private static final double MARS_GRAV = 0.37;
    private static final double VENUS_GRAV = 0.89;
    private static final double MERCURY_GRAV = 0.38;
    private static final double GANYMEDE_GRAV = 0.14;
    private static final double TITAN_GRAV = 0.14;
    private static final double EUROPA_GRAV = 0.13;
    public static double mercury_x = 0.0;
    public static double mercury_y = 0.0;
    public static float mercury_orbit_speed = 2.6179937E-4f;
    public static double mercury_orbit_radius_x = 100.0;
    public static double mercury_orbit_radius_y = 100.0;
    public static double mercury_origin_x = 0.0;
    public static double mercury_origin_y = 0.0;
    static int mercury_time;
    public static double venus_x;
    public static double venus_y;
    public static float venus_orbit_speed;
    public static double venus_orbit_radius_x;
    public static double venus_orbit_radius_y;
    public static double venus_origin_x;
    public static double venus_origin_y;
    static int venus_time;
    public static double earth_x;
    public static double earth_y;
    public static float earth_orbit_speed;
    public static double earth_orbit_radius_x;
    public static double earth_orbit_radius_y;
    public static double earth_origin_x;
    public static double earth_origin_y;
    static int earth_time;
    public static double earth_moon_x;
    public static double earth_moon_y;
    public static float earth_moon_orbit_speed;
    public static double earth_moon_orbit_radius_x;
    public static double earth_moon_orbit_radius_y;
    public static double earth_moon_origin_x;
    public static double earth_moon_origin_y;
    static int earth_moon_time;
    public static double moon_x;
    public static double moon_y;
    public static float moon_orbit_speed;
    public static double moon_orbit_radius_x;
    public static double moon_orbit_radius_y;
    static int moon_time;
    public static double mars_x;
    public static double mars_y;
    public static float mars_orbit_speed;
    public static double mars_orbit_radius_x;
    public static double mars_orbit_radius_y;
    public static double mars_origin_x;
    public static double mars_origin_y;
    static int mars_time;
    public static double pd_x;
    public static double pd_y;
    public static float pd_orbit_speed;
    public static double pd_orbit_radius_x;
    public static double pd_orbit_radius_y;
    static int pd_time;
    public static double ceres_x;
    public static double ceres_y;
    public static float ceres_orbit_speed;
    public static double ceres_orbit_radius_x;
    public static double ceres_orbit_radius_y;
    public static double ceres_origin_x;
    public static double ceres_origin_y;
    static int ceres_time;
    public static double jupiter_x;
    public static double jupiter_y;
    public static float jupiter_orbit_speed;
    public static double jupiter_orbit_radius_x;
    public static double jupiter_orbit_radius_y;
    public static double jupiter_origin_x;
    public static double jupiter_origin_y;
    static int jupiter_time;
    public static double saturn_x;
    public static double saturn_y;
    public static float saturn_orbit_speed;
    public static double saturn_orbit_radius_x;
    public static double saturn_orbit_radius_y;
    public static double saturn_origin_x;
    public static double saturn_origin_y;
    static int saturn_time;
    public static double uranus_x;
    public static double uranus_y;
    public static float uranus_orbit_speed;
    public static double uranus_orbit_radius_x;
    public static double uranus_orbit_radius_y;
    public static double uranus_origin_x;
    public static double uranus_origin_y;
    static int uranus_time;
    public static double neptune_x;
    public static double neptune_y;
    public static float neptune_orbit_speed;
    public static double neptune_orbit_radius_x;
    public static double neptune_orbit_radius_y;
    public static double neptune_origin_x;
    public static double neptune_origin_y;
    static int neptune_time;
    public static double pluto_x;
    public static double pluto_y;
    public static float pluto_orbit_speed;
    public static double pluto_orbit_radius_x;
    public static double pluto_orbit_radius_y;
    public static double pluto_origin_x;
    public static double pluto_origin_y;
    static int pluto_time;
    public static double eris_x;
    public static double eris_y;
    public static float eris_orbit_speed;
    public static double eris_orbit_radius_x;
    public static double eris_orbit_radius_y;
    public static double eris_origin_x;
    public static double eris_origin_y;
    static int eris_time;
    static long time;

    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Pre event) {
        time = event.getLevel().getGameTime() * 2L;
        double mercury_radian = mercury_orbit_speed * (float)time;
        mercury_x = mercury_origin_x + Math.cos(mercury_radian) * mercury_orbit_radius_x;
        mercury_y = mercury_origin_y + Math.sin(mercury_radian) * mercury_orbit_radius_y;
        double venus_radian = venus_orbit_speed * (float)time;
        venus_x = venus_origin_x + Math.cos(venus_radian) * venus_orbit_radius_x;
        venus_y = venus_origin_y + Math.sin(venus_radian) * venus_orbit_radius_y;
        double earth_radian = earth_orbit_speed * (float)time;
        earth_x = earth_origin_x + Math.cos(earth_radian) * earth_orbit_radius_x;
        earth_y = earth_origin_y + Math.sin(earth_radian) * earth_orbit_radius_y;
        double earth_moon_radian = earth_moon_orbit_speed * (float)time;
        earth_moon_x = earth_moon_origin_x + Math.cos(earth_moon_radian) * earth_moon_orbit_radius_x;
        earth_moon_y = earth_moon_origin_y + Math.sin(earth_moon_radian) * earth_moon_orbit_radius_y;
        double moon_radian = moon_orbit_speed * (float)time;
        moon_x = earth_x + Math.cos(moon_radian) * moon_orbit_radius_x;
        moon_y = earth_y + Math.sin(moon_radian) * moon_orbit_radius_y;
        double mars_radian = mars_orbit_speed * (float)time;
        mars_x = mars_origin_x + Math.cos(mars_radian) * mars_orbit_radius_x;
        mars_y = mars_origin_y + Math.sin(mars_radian) * mars_orbit_radius_y;
        double pd_radian = pd_orbit_speed * (float)time;
        pd_x = mars_x + Math.cos(pd_radian) * pd_orbit_radius_x;
        pd_y = mars_y + Math.sin(pd_radian) * pd_orbit_radius_y;
        double ceres_radian = ceres_orbit_speed * (float)time;
        ceres_x += Math.cos(ceres_radian) * ceres_orbit_radius_x;
        ceres_y += Math.sin(ceres_radian) * ceres_orbit_radius_y;
        double jupiter_radian = jupiter_orbit_speed * (float)time;
        jupiter_x = jupiter_origin_x + Math.cos(jupiter_radian) * jupiter_orbit_radius_x;
        jupiter_y = jupiter_origin_y + Math.sin(jupiter_radian) * jupiter_orbit_radius_y;
        double saturn_radian = saturn_orbit_speed * (float)time;
        saturn_x = saturn_origin_x + Math.cos(saturn_radian) * saturn_orbit_radius_x;
        saturn_y = saturn_origin_y + Math.sin(saturn_radian) * saturn_orbit_radius_y;
        double uranus_radian = uranus_orbit_speed * (float)time;
        uranus_x = uranus_origin_x + Math.cos(uranus_radian) * uranus_orbit_radius_x;
        uranus_y = uranus_origin_y + Math.sin(uranus_radian) * uranus_orbit_radius_y;
        double neptune_radian = neptune_orbit_speed * (float)time;
        neptune_x = neptune_origin_x + Math.cos(neptune_radian) * neptune_orbit_radius_x;
        neptune_y = neptune_origin_y + Math.sin(neptune_radian) * neptune_orbit_radius_y;
        double pluto_radian = pluto_orbit_speed * (float)time;
        pluto_x = pluto_origin_x + Math.cos(pluto_radian) * pluto_orbit_radius_x;
        pluto_y = pluto_origin_y + Math.sin(pluto_radian) * pluto_orbit_radius_y;
        double eris_radian = eris_orbit_speed * (float)time;
        eris_x = eris_origin_x + Math.cos(eris_radian) * eris_orbit_radius_x;
        eris_y = eris_origin_y + Math.sin(eris_radian) * eris_orbit_radius_y;
        Northstar.LOGGER.debug("{}   Mars X", (Object)mars_x);
        Northstar.LOGGER.debug("{}   Mars Y", (Object)mars_y);
    }

    public static double getPlanetX(String name) {
        return switch (name) {
            case "mercury" -> mercury_x;
            case "venus" -> venus_x;
            case "earth" -> earth_x;
            case "earth_moon" -> earth_moon_x;
            case "moon" -> moon_x;
            case "mars" -> mars_x;
            case "ceres" -> ceres_x;
            case "jupiter" -> jupiter_x;
            case "saturn" -> saturn_x;
            case "uranus" -> uranus_x;
            case "neptune" -> neptune_x;
            case "pluto" -> pluto_x;
            case "eris" -> eris_x;
            default -> 0.0;
        };
    }

    public static double getPlanetY(String name) {
        return switch (name) {
            case "mercury" -> mercury_y;
            case "venus" -> venus_y;
            case "earth" -> earth_y;
            case "earth_moon" -> earth_moon_y;
            case "moon" -> moon_y;
            case "mars" -> mars_y;
            case "ceres" -> ceres_y;
            case "jupiter" -> jupiter_y;
            case "saturn" -> saturn_y;
            case "uranus" -> uranus_y;
            case "neptune" -> neptune_y;
            case "pluto" -> pluto_y;
            case "eris" -> eris_y;
            default -> 0.0;
        };
    }

    public static String getPlanetName(ResourceKey<Level> level) {
        if (level == NorthstarDimensions.MARS_DIM_KEY) {
            return "mars";
        }
        if (level == NorthstarDimensions.MOON_DIM_KEY) {
            return "moon";
        }
        if (level == NorthstarDimensions.VENUS_DIM_KEY) {
            return "venus";
        }
        if (level == NorthstarDimensions.MERCURY_DIM_KEY) {
            return "mercury";
        }
        if (level == Level.OVERWORLD) {
            return "earth";
        }
        return "earth";
    }

    public static boolean planetHasSky(ResourceKey<Level> level) {
        if (level == NorthstarDimensions.EARTH_ORBIT_DIM_KEY) {
            return true;
        }
        if (level == NorthstarDimensions.MARS_DIM_KEY) {
            return true;
        }
        if (level == NorthstarDimensions.MOON_DIM_KEY) {
            return true;
        }
        if (level == NorthstarDimensions.VENUS_DIM_KEY) {
            return true;
        }
        if (level == NorthstarDimensions.MERCURY_DIM_KEY) {
            return true;
        }
        return level == Level.OVERWORLD;
    }

    public static int getPlanetTemp(ResourceKey<Level> level) {
        if (level == NorthstarDimensions.MARS_DIM_KEY) {
            return -100;
        }
        if (level == NorthstarDimensions.MOON_DIM_KEY) {
            return -183;
        }
        if (level == NorthstarDimensions.VENUS_DIM_KEY) {
            return 464;
        }
        if (level == NorthstarDimensions.MERCURY_DIM_KEY) {
            return 400;
        }
        if (level == Level.OVERWORLD) {
            return 15;
        }
        if (level == Level.NETHER) {
            return 230;
        }
        if (level == Level.END) {
            return 4;
        }
        return 15;
    }

    public static int getPlanetAtmosphereCost(ResourceKey<Level> level) {
        if (level == NorthstarDimensions.MARS_DIM_KEY) {
            return 200;
        }
        if (level == Level.OVERWORLD) {
            return 1600;
        }
        if (level == NorthstarDimensions.MOON_DIM_KEY) {
            return 0;
        }
        if (level == NorthstarDimensions.VENUS_DIM_KEY) {
            return 4000;
        }
        if (level == NorthstarDimensions.MERCURY_DIM_KEY) {
            return 0;
        }
        return 0;
    }

    public static int getComputingCost(ResourceKey<Level> level) {
        if (level == NorthstarDimensions.MARS_DIM_KEY) {
            return 400;
        }
        if (level == Level.OVERWORLD) {
            return 0;
        }
        if (level == NorthstarDimensions.MOON_DIM_KEY) {
            return 50;
        }
        if (level == NorthstarDimensions.VENUS_DIM_KEY) {
            return 200;
        }
        if (level == NorthstarDimensions.MERCURY_DIM_KEY) {
            return 800;
        }
        return 0;
    }

    @Nullable
    public static ResourceKey<Level> getPlanetDimension(String name) {
        return switch (name) {
            case "mercury" -> NorthstarDimensions.MERCURY_DIM_KEY;
            case "mars" -> NorthstarDimensions.MARS_DIM_KEY;
            case "venus" -> NorthstarDimensions.VENUS_DIM_KEY;
            case "earth" -> Level.OVERWORLD;
            case "earth_moon", "moon" -> NorthstarDimensions.MOON_DIM_KEY;
            default -> null;
        };
    }

    public static boolean getPlanetOxy(ResourceKey<Level> level) {
        if (level == NorthstarDimensions.MARS_DIM_KEY) {
            return false;
        }
        if (level == NorthstarDimensions.MERCURY_DIM_KEY) {
            return false;
        }
        if (level == NorthstarDimensions.MOON_DIM_KEY) {
            return false;
        }
        return level != NorthstarDimensions.VENUS_DIM_KEY;
    }

    public static boolean hasNormalGrav(ResourceKey<Level> level) {
        if (level == NorthstarDimensions.MARS_DIM_KEY) {
            return false;
        }
        if (level == NorthstarDimensions.MERCURY_DIM_KEY) {
            return false;
        }
        if (level == NorthstarDimensions.MOON_DIM_KEY) {
            return false;
        }
        return level != NorthstarDimensions.VENUS_DIM_KEY;
    }

    public static boolean canSeeSkyAtDay(ResourceKey<Level> level) {
        if (level == NorthstarDimensions.EARTH_ORBIT_DIM_KEY) {
            return true;
        }
        if (level == NorthstarDimensions.MERCURY_DIM_KEY) {
            return true;
        }
        return level == NorthstarDimensions.MOON_DIM_KEY;
    }

    public static boolean hasWeather(ResourceKey<Level> level) {
        if (level == NorthstarDimensions.EARTH_ORBIT_DIM_KEY) {
            return false;
        }
        if (level == NorthstarDimensions.MERCURY_DIM_KEY) {
            return false;
        }
        return level != NorthstarDimensions.MOON_DIM_KEY;
    }

    public static double getGravMultiplier(ResourceKey<Level> level) {
        if (level == NorthstarDimensions.MOON_DIM_KEY) {
            return 0.16;
        }
        if (level == NorthstarDimensions.MARS_DIM_KEY) {
            return 0.37;
        }
        if (level == NorthstarDimensions.MERCURY_DIM_KEY) {
            return 0.38;
        }
        if (level == NorthstarDimensions.VENUS_DIM_KEY) {
            return 0.89;
        }
        if (level == NorthstarDimensions.EARTH_ORBIT_DIM_KEY) {
            return 0.06;
        }
        return 1.0;
    }

    public static double getEngineConstant(ResourceKey<Level> level) {
        if (level == NorthstarDimensions.MOON_DIM_KEY) {
            return 1.0;
        }
        if (level == NorthstarDimensions.MARS_DIM_KEY) {
            return 3.0;
        }
        if (level == NorthstarDimensions.MERCURY_DIM_KEY) {
            return 6.0;
        }
        if (level == NorthstarDimensions.VENUS_DIM_KEY) {
            return 9.0;
        }
        if (level == NorthstarDimensions.EARTH_ORBIT_DIM_KEY) {
            return 1.0;
        }
        return 1.0;
    }

    public static float getWindMultiplier(Level level) {
        ResourceKey dim = level.dimension();
        if (dim == NorthstarDimensions.MOON_DIM_KEY) {
            return 0.0f;
        }
        if (dim == NorthstarDimensions.MARS_DIM_KEY) {
            if (level.isRaining()) {
                return 1.0f;
            }
            return 0.0f;
        }
        if (dim == NorthstarDimensions.MERCURY_DIM_KEY) {
            return 0.0f;
        }
        if (dim == NorthstarDimensions.VENUS_DIM_KEY) {
            if (level.isRaining()) {
                return 0.7f;
            }
            return 0.5f;
        }
        if (dim == NorthstarDimensions.EARTH_ORBIT_DIM_KEY) {
            return 0.0f;
        }
        return 1.0f;
    }

    public static boolean isCustomDimension(ResourceLocation resourceLocation) {
        if (resourceLocation == NorthstarDimensions.MARS_DIM_KEY.location()) {
            return true;
        }
        if (resourceLocation == NorthstarDimensions.MERCURY_DIM_KEY.location()) {
            return true;
        }
        if (resourceLocation == NorthstarDimensions.MOON_DIM_KEY.location()) {
            return true;
        }
        return resourceLocation == NorthstarDimensions.VENUS_DIM_KEY.location();
    }

    public static long getSeedOffset(ResourceKey<Level> level) {
        if (level == NorthstarDimensions.MARS_DIM_KEY) {
            return 1L;
        }
        if (level == NorthstarDimensions.MERCURY_DIM_KEY) {
            return 2L;
        }
        if (level == NorthstarDimensions.MOON_DIM_KEY) {
            return 3L;
        }
        if (level == NorthstarDimensions.VENUS_DIM_KEY) {
            return 4L;
        }
        return 0L;
    }

    public static float getSunMultiplier(ResourceKey<Level> level) {
        if (level == Level.OVERWORLD) {
            return 1.0f;
        }
        if (level == NorthstarDimensions.MERCURY_DIM_KEY) {
            return 8.0f;
        }
        if (level == NorthstarDimensions.VENUS_DIM_KEY) {
            return 0.6f;
        }
        if (level == NorthstarDimensions.MOON_DIM_KEY) {
            return 1.5f;
        }
        if (level == NorthstarDimensions.MARS_DIM_KEY) {
            return 1.2f;
        }
        return 1.0f;
    }

    public static boolean isInOrbit(ResourceKey<Level> level) {
        return level == NorthstarDimensions.EARTH_ORBIT_DIM_KEY;
    }

    public static boolean isInterplanetary(ResourceKey<Level> home, ResourceKey<Level> dest) {
        boolean flag = true;
        if (home == Level.OVERWORLD && dest == NorthstarDimensions.MOON_DIM_KEY || dest == Level.OVERWORLD && home == NorthstarDimensions.MOON_DIM_KEY || dest == home) {
            flag = false;
        }
        return flag;
    }

    public static void register() {
    }

    static {
        venus_x = 0.0;
        venus_y = 0.0;
        venus_orbit_speed = 9.817477E-5f;
        venus_orbit_radius_x = 150.0;
        venus_orbit_radius_y = 150.0;
        venus_origin_x = 0.0;
        venus_origin_y = 0.0;
        earth_x = 0.0;
        earth_y = 0.0;
        earth_orbit_speed = 9.817477E-5f;
        earth_orbit_radius_x = 200.0;
        earth_orbit_radius_y = 200.0;
        earth_origin_x = 0.0;
        earth_origin_y = 0.0;
        earth_moon_x = 0.0;
        earth_moon_y = 0.0;
        earth_moon_orbit_speed = 2.0943951E-5f;
        earth_moon_orbit_radius_x = 40.0;
        earth_moon_orbit_radius_y = 40.0;
        earth_moon_origin_x = 0.0;
        earth_moon_origin_y = 0.0;
        moon_x = 0.0;
        moon_y = 0.0;
        moon_orbit_speed = 3.1415926E-4f;
        moon_orbit_radius_x = 20.0;
        moon_orbit_radius_y = 20.0;
        mars_x = 0.0;
        mars_y = 0.0;
        mars_orbit_speed = 3.1415926E-5f;
        mars_orbit_radius_x = 250.0;
        mars_orbit_radius_y = 250.0;
        mars_origin_x = 0.0;
        mars_origin_y = 0.0;
        pd_x = 0.0;
        pd_y = 0.0;
        pd_orbit_speed = 3.1415926E-4f;
        pd_orbit_radius_x = 20.0;
        pd_orbit_radius_y = 20.0;
        ceres_x = 0.0;
        ceres_y = 0.0;
        ceres_orbit_speed = 1.5707963E-5f;
        ceres_orbit_radius_x = 260.0;
        ceres_orbit_radius_y = 260.0;
        ceres_origin_x = 0.0;
        ceres_origin_y = 0.0;
        jupiter_x = 0.0;
        jupiter_y = 0.0;
        jupiter_orbit_speed = 9.817477E-5f;
        jupiter_orbit_radius_x = 270.0;
        jupiter_orbit_radius_y = 270.0;
        jupiter_origin_x = 0.0;
        jupiter_origin_y = 0.0;
        saturn_x = 0.0;
        saturn_y = 0.0;
        saturn_orbit_speed = 7.8539815E-5f;
        saturn_orbit_radius_x = 300.0;
        saturn_orbit_radius_y = 300.0;
        saturn_origin_x = 0.0;
        saturn_origin_y = 0.0;
        uranus_x = 0.0;
        uranus_y = 0.0;
        uranus_orbit_speed = 6.283185E-5f;
        uranus_orbit_radius_x = 375.0;
        uranus_orbit_radius_y = 375.0;
        uranus_origin_x = 0.0;
        uranus_origin_y = 0.0;
        neptune_x = 0.0;
        neptune_y = 0.0;
        neptune_orbit_speed = 3.9269908E-5f;
        neptune_orbit_radius_x = 450.0;
        neptune_orbit_radius_y = 450.0;
        neptune_origin_x = 0.0;
        neptune_origin_y = 0.0;
        pluto_x = 0.0;
        pluto_y = 0.0;
        pluto_orbit_speed = 2.0943951E-5f;
        pluto_orbit_radius_x = 525.0;
        pluto_orbit_radius_y = 515.0;
        pluto_origin_x = 0.0;
        pluto_origin_y = 0.0;
        eris_x = 0.0;
        eris_y = 0.0;
        eris_orbit_speed = 1.9634955E-4f;
        eris_orbit_radius_x = 1000.0;
        eris_orbit_radius_y = 600.0;
        eris_origin_x = 0.0;
        eris_origin_y = 0.0;
    }
}

