/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.features;

import com.lightning.northstar.block.crops.VenusVinesBlock;
import com.lightning.northstar.world.features.configuration.RoofVinesConfig;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class RoofVinesFeature
extends Feature<RoofVinesConfig> {
    public RoofVinesFeature(Codec<RoofVinesConfig> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<RoofVinesConfig> pContext) {
        WorldGenLevel worldgenlevel = pContext.level();
        BlockPos blockpos = pContext.origin();
        RandomSource randomsource = pContext.random();
        if (!worldgenlevel.isEmptyBlock(blockpos)) {
            return false;
        }
        RoofVinesConfig config = (RoofVinesConfig)pContext.config();
        this.placeVines((LevelAccessor)worldgenlevel, randomsource, blockpos, config);
        return true;
    }

    private void placeVines(LevelAccessor pLevel, RandomSource pRandom, BlockPos pPos, RoofVinesConfig config) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 100; ++i) {
            BlockState blockstate;
            blockpos$mutableblockpos.setWithOffset((Vec3i)pPos, pRandom.nextInt(8) - pRandom.nextInt(8), pRandom.nextInt(2) - pRandom.nextInt(7), pRandom.nextInt(8) - pRandom.nextInt(8));
            if (!pLevel.isEmptyBlock((BlockPos)blockpos$mutableblockpos) || !(blockstate = pLevel.getBlockState(blockpos$mutableblockpos.above())).isSolidRender((BlockGetter)pLevel, blockpos$mutableblockpos.above())) continue;
            int j = Mth.nextInt((RandomSource)pRandom, (int)1, (int)config.size().sample(pRandom));
            if (pRandom.nextInt(6) == 0) {
                j *= 2;
            }
            if (pRandom.nextInt(5) == 0) {
                j = 1;
            }
            RoofVinesFeature.placeWeepingVinesColumn(pLevel, pRandom, blockpos$mutableblockpos, j, config.blockProvider(), config.glowProvider());
        }
    }

    public static void placeWeepingVinesColumn(LevelAccessor pLevel, RandomSource pRandom, BlockPos.MutableBlockPos pPos, int pHeight, BlockStateProvider normalState, BlockStateProvider glowState) {
        for (int i = 0; i <= pHeight; ++i) {
            if (pLevel.isEmptyBlock((BlockPos)pPos)) {
                BlockState newstate = normalState.getState(pRandom, (BlockPos)pPos);
                if (pRandom.nextInt(4) == 0) {
                    newstate = glowState.getState(pRandom, (BlockPos)pPos);
                }
                if (i == pHeight || !pLevel.isEmptyBlock(pPos.below())) {
                    pLevel.setBlock((BlockPos)pPos, (BlockState)newstate.setValue((Property)VenusVinesBlock.IS_TIP, (Comparable)Boolean.valueOf(true)), 2);
                    break;
                }
                pLevel.setBlock((BlockPos)pPos, (BlockState)newstate.setValue((Property)VenusVinesBlock.IS_TIP, (Comparable)Boolean.valueOf(false)), 2);
            }
            pPos.move(Direction.DOWN);
        }
    }
}

