/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.crops;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;
import org.jetbrains.annotations.Nullable;

public class TallFungusBlock
extends TallFlowerBlock {
    protected static final BooleanProperty IS_ON_CEILING = BooleanProperty.create((String)"is_on_ceiling");
    private final ResourceKey<ConfiguredFeature<?, ?>> ground;
    private final ResourceKey<ConfiguredFeature<?, ?>> ceiling;

    public TallFungusBlock(BlockBehaviour.Properties properties, ResourceKey<ConfiguredFeature<?, ?>> ground, ResourceKey<ConfiguredFeature<?, ?>> ceiling) {
        super(properties);
        this.ground = ground;
        this.ceiling = ceiling;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)IS_ON_CEILING, (Comparable)Boolean.valueOf(false))).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{IS_ON_CEILING}));
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        if (!((Boolean)pState.getValue((Property)IS_ON_CEILING)).booleanValue()) {
            if (pState.getValue((Property)HALF) != DoubleBlockHalf.UPPER) {
                return pLevel.getBlockState(pPos.below()).isSolidRender((BlockGetter)pLevel, pPos.below());
            }
            BlockState blockstate = pLevel.getBlockState(pPos.below());
            if (pState.getBlock() != this) {
                return this.mayPlaceOn(pState, (BlockGetter)pLevel, pPos);
            }
            return blockstate.is((Block)this) && blockstate.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
        }
        if (pState.getValue((Property)HALF) != DoubleBlockHalf.UPPER) {
            return pLevel.getBlockState(pPos.above()).isSolidRender((BlockGetter)pLevel, pPos.above());
        }
        BlockState blockstate = pLevel.getBlockState(pPos.above());
        if (pState.getBlock() != this) {
            return this.mayPlaceOn(pState, (BlockGetter)pLevel, pPos);
        }
        return blockstate.is((Block)this) && blockstate.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (!((Boolean)pState.getValue((Property)IS_ON_CEILING)).booleanValue()) {
            DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)pState.getValue((Property)HALF);
            if (pFacing.getAxis() != Direction.Axis.Y || doubleblockhalf == DoubleBlockHalf.LOWER != (pFacing == Direction.UP) || pFacingState.is((Block)this) && pFacingState.getValue((Property)HALF) != doubleblockhalf) {
                return doubleblockhalf == DoubleBlockHalf.LOWER && pFacing == Direction.DOWN && !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
            }
            return Blocks.AIR.defaultBlockState();
        }
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)pState.getValue((Property)HALF);
        if (doubleblockhalf == DoubleBlockHalf.LOWER && !pLevel.getBlockState(pCurrentPos.below()).is((Block)this)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (pFacing.getAxis() != Direction.Axis.Y || doubleblockhalf == DoubleBlockHalf.LOWER != (pFacing == Direction.UP) || pFacingState.is((Block)this) && pFacingState.getValue((Property)HALF) != doubleblockhalf) {
            return doubleblockhalf == DoubleBlockHalf.LOWER && pFacing == Direction.UP && !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        boolean ceiling_flag = pContext.getClickedFace() == Direction.DOWN;
        BlockPos blockpos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        if (ceiling_flag) {
            return blockpos.getY() < level.getMaxBuildHeight() && level.getBlockState(blockpos.below()).canBeReplaced(pContext) ? (BlockState)this.defaultBlockState().setValue((Property)IS_ON_CEILING, (Comparable)Boolean.valueOf(ceiling_flag)) : null;
        }
        return blockpos.getY() < level.getMaxBuildHeight() && level.getBlockState(blockpos.above()).canBeReplaced(pContext) ? (BlockState)((BlockState)this.defaultBlockState().setValue((Property)IS_ON_CEILING, (Comparable)Boolean.valueOf(ceiling_flag))).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER) : null;
    }

    public static void placeAt(LevelAccessor pLevel, BlockState pState, BlockPos pPos, int pFlags) {
        BlockPos blockpos = pPos.above();
        if (pLevel.getBlockState(blockpos).isSolidRender((BlockGetter)pLevel, blockpos)) {
            pLevel.setBlock(pPos, TallFungusBlock.copyWaterloggedFrom((LevelReader)pLevel, (BlockPos)pPos, (BlockState)((BlockState)((BlockState)pState.setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)IS_ON_CEILING, (Comparable)Boolean.valueOf(true)))), pFlags);
            pLevel.setBlock(pPos.below(), TallFungusBlock.copyWaterloggedFrom((LevelReader)pLevel, (BlockPos)pPos.below(), (BlockState)((BlockState)((BlockState)pState.setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)IS_ON_CEILING, (Comparable)Boolean.valueOf(true)))), pFlags);
        } else {
            pLevel.setBlock(pPos, TallFungusBlock.copyWaterloggedFrom((LevelReader)pLevel, (BlockPos)pPos, (BlockState)((BlockState)pState.setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER))), pFlags);
            pLevel.setBlock(blockpos, TallFungusBlock.copyWaterloggedFrom((LevelReader)pLevel, (BlockPos)blockpos, (BlockState)((BlockState)pState.setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER))), pFlags);
        }
    }

    protected boolean mayPlaceOn(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        if (((Boolean)pState.getValue((Property)IS_ON_CEILING)).booleanValue()) {
            return pState.isSolidRender(pLevel, pPos.above());
        }
        return pState.isSolidRender(pLevel, pPos);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockPos otherPos = (Boolean)state.getValue((Property)IS_ON_CEILING) != false ? pos.below() : pos.above();
        BlockState otherState = TallFungusBlock.copyWaterloggedFrom((LevelReader)level, (BlockPos)otherPos, (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)IS_ON_CEILING, (Comparable)Boolean.valueOf(true))));
        level.setBlock(otherPos, otherState, 3);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockGrowFeatureEvent event;
        Optional feature = level.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE).getHolder((Boolean)state.getValue((Property)IS_ON_CEILING) != false ? this.ceiling : this.ground);
        if (feature.isEmpty()) {
            return;
        }
        BlockPos placePos = pos;
        if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER && ((Boolean)state.getValue((Property)IS_ON_CEILING)).booleanValue()) {
            placePos = placePos.above();
        }
        if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER && !((Boolean)state.getValue((Property)IS_ON_CEILING)).booleanValue()) {
            placePos = placePos.below();
        }
        if ((event = EventHooks.fireBlockGrowFeature((LevelAccessor)level, (RandomSource)random, (BlockPos)placePos, (Holder)((Holder)feature.get()))).isCanceled()) {
            return;
        }
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 0);
        level.setBlock(placePos, Blocks.AIR.defaultBlockState(), 0);
        if (((ConfiguredFeature)event.getFeature().value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), random, placePos)) {
            return;
        }
        level.setBlock(pos, state, 3);
    }
}

