/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.lightning.northstar.block.simple.MarsSoilBlock;
import com.lightning.northstar.block.simple.MartianTallGrassBlock;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.world.NorthstarTemperature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.BlockLightEngine;
import net.neoforged.neoforge.common.util.TriState;

public class MartianGrassBlock
extends Block
implements BonemealableBlock {
    public MartianGrassBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    private static boolean canBeGrass(BlockState pState, LevelReader pLevelReader, BlockPos pPos) {
        BlockPos blockpos = pPos.above();
        BlockState blockstate = pLevelReader.getBlockState(blockpos);
        if (blockstate.getFluidState().getAmount() == 8) {
            return false;
        }
        int i = BlockLightEngine.getLightBlockInto((BlockGetter)pLevelReader, (BlockState)pState, (BlockPos)pPos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.getLightBlock((BlockGetter)pLevelReader, blockpos));
        return i < pLevelReader.getMaxLightLevel() && NorthstarTemperature.getTemperatureAt((Level)pLevelReader, (Vec3i)pPos) > 0.0f;
    }

    public TriState canSustainPlant(BlockState state, BlockGetter level, BlockPos soilPosition, Direction facing, BlockState plant) {
        if (plant.getBlock() instanceof CropBlock || plant.is(BlockTags.CROPS)) {
            return TriState.FALSE;
        }
        return super.canSustainPlant(state, level, soilPosition, facing, plant);
    }

    private static boolean canPropagate(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.above();
        return MartianGrassBlock.canBeGrass(pState, pLevel, pPos) && !pLevel.getFluidState(blockpos).is(FluidTags.WATER);
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!MartianGrassBlock.canBeGrass(pState, (LevelReader)pLevel, pPos)) {
            if (!pLevel.isAreaLoaded(pPos, 1)) {
                return;
            }
            if (pRandom.nextInt(5) == 0) {
                pLevel.setBlockAndUpdate(pPos, ((MarsSoilBlock)((Object)NorthstarBlocks.MARS_SOIL.get())).defaultBlockState());
            }
        } else {
            if (!pLevel.isAreaLoaded(pPos, 3)) {
                return;
            }
            if (pLevel.getMaxLocalRawBrightness(pPos.above()) >= 9) {
                BlockState blockstate = this.defaultBlockState();
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pPos.offset(pRandom.nextInt(3) - 1, pRandom.nextInt(5) - 3, pRandom.nextInt(3) - 1);
                    if (!pLevel.getBlockState(blockpos).is((Block)NorthstarBlocks.MARS_SOIL.get()) || !MartianGrassBlock.canPropagate(blockstate, (LevelReader)pLevel, blockpos)) continue;
                    pLevel.setBlockAndUpdate(blockpos, blockstate);
                }
            }
        }
    }

    public boolean isValidBonemealTarget(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return pLevel.getBlockState(pPos.above()).isAir();
    }

    public boolean isBonemealSuccess(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        BlockState blockstate = ((MartianTallGrassBlock)((Object)NorthstarBlocks.MARTIAN_TALL_GRASS.get())).defaultBlockState();
        if (pRandom.nextBoolean() && level.getBlockState(pPos.above()).isAir()) {
            level.setBlock(pPos.above(), blockstate, 2);
        }
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos pos = new BlockPos(pPos.getX() + x, pPos.getY() + y, pPos.getZ() + z);
                    BlockState state = level.getBlockState(pos.below());
                    if (!level.getBlockState(pos).isAir() || !pState.is((Block)NorthstarBlocks.MARTIAN_GRASS.get()) && !state.is((Block)NorthstarBlocks.MARS_SOIL.get()) || pRandom.nextInt(2) != 0) continue;
                    level.setBlock(pos, blockstate, 2);
                }
            }
        }
    }
}

