/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.simple;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;
import org.jetbrains.annotations.Nullable;

public class VenusMushroomBlock
extends BushBlock
implements BonemealableBlock {
    private static final MapCodec<VenusMushroomBlock> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)BlockBehaviour.Properties.CODEC.fieldOf("properties").forGetter(BlockBehaviour::properties), (App)ResourceKey.codec((ResourceKey)Registries.CONFIGURED_FEATURE).fieldOf("ground").forGetter(b -> b.ground), (App)ResourceKey.codec((ResourceKey)Registries.CONFIGURED_FEATURE).fieldOf("ceiling").forGetter(b -> b.ceiling)).apply((Applicative)i, VenusMushroomBlock::new));
    protected static final BooleanProperty IS_ON_CEILING = BooleanProperty.create((String)"is_on_ceiling");
    protected static final VoxelShape GROUND_SHAPE = VenusMushroomBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0);
    protected static final VoxelShape CEILING_SHAPE = VenusMushroomBlock.box((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private final ResourceKey<ConfiguredFeature<?, ?>> ground;
    private final ResourceKey<ConfiguredFeature<?, ?>> ceiling;

    public VenusMushroomBlock(BlockBehaviour.Properties properties, ResourceKey<ConfiguredFeature<?, ?>> ground, ResourceKey<ConfiguredFeature<?, ?>> ceiling) {
        super(properties);
        this.ground = ground;
        this.ceiling = ceiling;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)IS_ON_CEILING, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{IS_ON_CEILING}));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)IS_ON_CEILING) != false ? CEILING_SHAPE : GROUND_SHAPE;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos otherPos = (Boolean)state.getValue((Property)IS_ON_CEILING) != false ? pos.above() : pos.below();
        Direction direction = (Boolean)state.getValue((Property)IS_ON_CEILING) != false ? Direction.DOWN : Direction.UP;
        BlockState blockstate = level.getBlockState(otherPos);
        return blockstate.is(BlockTags.MUSHROOM_GROW_BLOCK) || blockstate.canSustainPlant((BlockGetter)level, otherPos, direction, state).isTrue();
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.isSolidRender(level, pos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)IS_ON_CEILING, (Comparable)Boolean.valueOf(context.getClickedFace() == Direction.DOWN));
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return ((Boolean)state.getValue((Property)IS_ON_CEILING)).booleanValue() ? ((VenusMushroomBlock)state.getBlock()).ceiling != null : ((VenusMushroomBlock)state.getBlock()).ground != null;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return ((Boolean)state.getValue((Property)IS_ON_CEILING)).booleanValue() ? ((VenusMushroomBlock)state.getBlock()).ceiling != null : ((VenusMushroomBlock)state.getBlock()).ground != null;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        Optional feature = level.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE).getHolder((Boolean)state.getValue((Property)IS_ON_CEILING) != false ? this.ceiling : this.ground);
        if (feature.isEmpty()) {
            return;
        }
        BlockGrowFeatureEvent event = EventHooks.fireBlockGrowFeature((LevelAccessor)level, (RandomSource)random, (BlockPos)pos, (Holder)((Holder)feature.get()));
        if (event.isCanceled()) {
            return;
        }
        level.removeBlock(pos, false);
        if (((ConfiguredFeature)event.getFeature().value()).place((WorldGenLevel)level, level.getChunkSource().getGenerator(), random, pos)) {
            return;
        }
        level.setBlock(pos, state, 3);
    }
}

