/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.jet_engine;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

@ParametersAreNonnullByDefault
public class JetEngineBlock
extends Block
implements IWrenchable {
    public static final BooleanProperty TOP = BooleanProperty.create((String)"top");
    public static final BooleanProperty BOTTOM = BooleanProperty.create((String)"bottom");

    public JetEngineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TOP, (Comparable)Boolean.valueOf(false))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TOP, BOTTOM});
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moved) {
        if (!(oldState.getBlock() instanceof JetEngineBlock)) {
            this.updateConnectivity(world, pos, true);
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!(newState.getBlock() instanceof JetEngineBlock)) {
            this.updateConnectivity(world, pos, false);
        }
    }

    private void updateConnectivity(Level world, BlockPos pos, boolean added) {
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)TOP, (Comparable)Boolean.valueOf(this.updateConnectivity(world, pos.above(), added, BOTTOM)))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(this.updateConnectivity(world, pos.below(), added, TOP)));
        if (added) {
            world.setBlock(pos, state, 22);
        }
    }

    private boolean updateConnectivity(Level world, BlockPos pos, boolean added, BooleanProperty prop) {
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof JetEngineBlock) {
            world.setBlock(pos, (BlockState)state.setValue((Property)prop, (Comparable)Boolean.valueOf(added)), 22);
            return true;
        }
        return false;
    }
}

