/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.temperature_regulator;

import com.lightning.northstar.block.tech.temperature_regulator.MovingTemperatureRegulator;
import com.lightning.northstar.block.tech.temperature_regulator.TemperatureRegulatorBlockEntity;
import com.lightning.northstar.content.NorthstarPackets;
import com.lightning.northstar.contraption.ActorConfigPacket;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.foundation.utility.AdventureUtil;
import io.netty.buffer.ByteBuf;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.MutablePair;

public class TemperatureRegulatorEditPacket
implements ServerboundPacketPayload {
    public static final StreamCodec<ByteBuf, TemperatureRegulatorEditPacket> STREAM_CODEC = new StreamCodec<ByteBuf, TemperatureRegulatorEditPacket>(){

        public TemperatureRegulatorEditPacket decode(ByteBuf object) {
            return new TemperatureRegulatorEditPacket((Integer)ByteBufCodecs.INT.decode((Object)object), (BlockPos)BlockPos.STREAM_CODEC.decode((Object)object), (Integer)ByteBufCodecs.INT.decode((Object)object), (Boolean)ByteBufCodecs.BOOL.decode((Object)object), TemperatureRegulatorEditPacket.clampSize((Integer)ByteBufCodecs.INT.decode((Object)object)), TemperatureRegulatorEditPacket.clampSize((Integer)ByteBufCodecs.INT.decode((Object)object)), TemperatureRegulatorEditPacket.clampSize((Integer)ByteBufCodecs.INT.decode((Object)object)));
        }

        public void encode(ByteBuf object, TemperatureRegulatorEditPacket packet) {
            ByteBufCodecs.INT.encode((Object)object, (Object)packet.contraptionId);
            BlockPos.STREAM_CODEC.encode((Object)object, (Object)packet.pos);
            ByteBufCodecs.INT.encode((Object)object, (Object)packet.temperature);
            ByteBufCodecs.BOOL.encode((Object)object, (Object)packet.limit);
            ByteBufCodecs.INT.encode((Object)object, (Object)packet.sizeX);
            ByteBufCodecs.INT.encode((Object)object, (Object)packet.sizeY);
            ByteBufCodecs.INT.encode((Object)object, (Object)packet.sizeZ);
        }
    };
    private final int contraptionId;
    private final BlockPos pos;
    private final int temperature;
    private final boolean limit;
    private final int sizeX;
    private final int sizeY;
    private final int sizeZ;

    public TemperatureRegulatorEditPacket(int contraptionId, BlockPos pos, int temperature, boolean limit, int sizeX, int sizeY, int sizeZ) {
        this.contraptionId = contraptionId;
        this.pos = pos;
        this.temperature = temperature;
        this.limit = limit;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return NorthstarPackets.UPDATE_TEMPERATURE_REGULATOR;
    }

    public void handle(ServerPlayer player) {
        if (player == null || player.isSpectator() || AdventureUtil.isAdventure((Player)player)) {
            return;
        }
        Level world = player.level();
        Entity entity = world.getEntity(this.contraptionId);
        if (entity instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity entity2 = (AbstractContraptionEntity)entity;
            this.handleContraption(player, entity2);
        } else {
            this.handleWorld(player, world);
        }
    }

    private void handleContraption(ServerPlayer player, AbstractContraptionEntity entity) {
        MutablePair actor = entity.getContraption().getActorAt(this.pos);
        if (actor == null) {
            return;
        }
        Object object = ((MovementContext)actor.right).temporaryData;
        if (!(object instanceof MovingTemperatureRegulator)) {
            return;
        }
        MovingTemperatureRegulator regulator = (MovingTemperatureRegulator)object;
        BlockPos localPos = regulator.context.localPos;
        if (!entity.toGlobalVector(Vec3.atBottomCenterOf((Vec3i)localPos), 0.0f).closerThan((Position)player.position(), 20.0)) {
            return;
        }
        regulator.regulator.temperature = this.temperature;
        regulator.regulator.setBounds((Vec3i)localPos, this.limit, this.sizeX, this.sizeY, this.sizeZ);
        CompoundTag nbt = ((StructureTemplate.StructureBlockInfo)actor.left).nbt() == null ? new CompoundTag() : ((StructureTemplate.StructureBlockInfo)actor.left).nbt().copy();
        regulator.regulator.write(nbt);
        actor.left = new StructureTemplate.StructureBlockInfo(localPos, ((StructureTemplate.StructureBlockInfo)actor.left).state(), nbt);
        entity.setBlock(localPos, (StructureTemplate.StructureBlockInfo)actor.left);
        CatnipServices.NETWORK.sendToClientsTrackingEntity((Entity)entity, (CustomPacketPayload)new ActorConfigPacket(entity.getId(), localPos, nbt));
    }

    private void handleWorld(ServerPlayer player, Level world) {
        if (!world.isLoaded(this.pos) || !this.pos.closerThan((Vec3i)player.blockPosition(), 20.0)) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(this.pos);
        if (blockEntity instanceof TemperatureRegulatorBlockEntity) {
            TemperatureRegulatorBlockEntity be = (TemperatureRegulatorBlockEntity)blockEntity;
            be.regulator.temperature = this.temperature;
            be.regulator.setBounds((Vec3i)be.getBlockPos(), this.limit, this.sizeX, this.sizeY, this.sizeZ);
            be.sendData();
            be.setChanged();
        }
    }

    private static int clampSize(int size) {
        return Mth.clamp((int)size, (int)1, (int)5);
    }
}

