/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.content;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.content.NorthstarCreativeModeTab;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.fluid.TitaniumTetrachlorideBlock;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.fluids.VirtualFluid;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class NorthstarFluids {
    public static final FluidEntry<VirtualFluid> OXYGEN;
    public static final FluidEntry<VirtualFluid> HYDROGEN;
    public static final FluidEntry<VirtualFluid> CHLORINE;
    public static final FluidEntry<VirtualFluid> CHOCOLATE_ICE_CREAM;
    public static final FluidEntry<VirtualFluid> VANILLA_ICE_CREAM;
    public static final FluidEntry<VirtualFluid> STRAWBERRY_ICE_CREAM;
    public static final FluidEntry<VirtualFluid> SODIUM;
    public static final FluidEntry<VirtualFluid> CARBON;
    public static final FluidEntry<BaseFlowingFluid.Flowing> TITANIUM_TETRACHLORIDE;
    public static final FluidEntry<BaseFlowingFluid.Flowing> BRINE;
    public static final FluidEntry<BaseFlowingFluid.Flowing> LIQUID_HYDROGEN;
    public static final FluidEntry<BaseFlowingFluid.Flowing> LIQUID_OXYGEN;
    public static final FluidEntry<BaseFlowingFluid.Flowing> METHANE;
    public static final FluidEntry<BaseFlowingFluid.Flowing> SULFURIC_ACID;
    public static final FluidEntry<BaseFlowingFluid.Flowing> HYDROCARBON;
    public static final FluidEntry<BaseFlowingFluid.Flowing> BIOFUEL;

    public static void register() {
    }

    static {
        Northstar.REGISTRATE.setCreativeTab(NorthstarCreativeModeTab.ITEMS);
        OXYGEN = Northstar.REGISTRATE.virtualFluid("oxygen").tag(new TagKey[]{NorthstarTags.NorthstarFluidTags.C_GASEOUS.tag}).tag(new TagKey[]{NorthstarTags.NorthstarFluidTags.C_OXYGEN.tag}).register();
        HYDROGEN = Northstar.REGISTRATE.virtualFluid("hydrogen").tag(new TagKey[]{NorthstarTags.NorthstarFluidTags.C_GASEOUS.tag}).tag(new TagKey[]{NorthstarTags.NorthstarFluidTags.C_HYDROGEN.tag}).register();
        CHLORINE = Northstar.REGISTRATE.virtualFluid("chlorine").tag(new TagKey[]{NorthstarTags.NorthstarFluidTags.C_GASEOUS.tag}).tag(new TagKey[]{NorthstarTags.NorthstarFluidTags.C_CHLORINE.tag}).register();
        CHOCOLATE_ICE_CREAM = Northstar.REGISTRATE.virtualFluid("chocolate_ice_cream").tag(new TagKey[]{NorthstarTags.NorthstarFluidTags.C_CHOCOLATE_ICE_CREAM.tag}).register();
        VANILLA_ICE_CREAM = Northstar.REGISTRATE.virtualFluid("vanilla_ice_cream").tag(new TagKey[]{NorthstarTags.NorthstarFluidTags.C_VANILLA_ICE_CREAM.tag}).register();
        STRAWBERRY_ICE_CREAM = Northstar.REGISTRATE.virtualFluid("strawberry_ice_cream").tag(new TagKey[]{NorthstarTags.NorthstarFluidTags.C_STRAWBERRY_ICE_CREAM.tag}).register();
        SODIUM = Northstar.REGISTRATE.virtualFluid("sodium").tag(new TagKey[]{NorthstarTags.NorthstarFluidTags.C_SODIUM.tag}).register();
        CARBON = Northstar.REGISTRATE.virtualFluid("carbon").tag(new TagKey[]{NorthstarTags.NorthstarFluidTags.C_CARBON.tag}).register();
        TITANIUM_TETRACHLORIDE = ((FluidBuilder)Northstar.REGISTRATE.standardFluid("titanium_tetrachloride", SolidRenderedPlaceableFluidType.create(0xA59999, -553648129, () -> Float.valueOf(0.1f))).properties(b -> b.viscosity(4000).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(8).slopeFindDistance(3).explosionResistance(100.0f)).tag(new TagKey[]{NorthstarTags.NorthstarFluidTags.C_TITANIUM_TETRACHLORIDE.tag}).source(BaseFlowingFluid.Source::new).block(TitaniumTetrachlorideBlock::new).build()).register();
        BRINE = ((FluidBuilder)Northstar.REGISTRATE.standardFluid("brine", SolidRenderedPlaceableFluidType.create(0xA59999, -553648129, () -> Float.valueOf(0.1f))).properties(b -> b.viscosity(2000).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(5).slopeFindDistance(3).explosionResistance(100.0f)).tag(new TagKey[]{NorthstarTags.NorthstarFluidTags.C_BRINE.tag}).source(BaseFlowingFluid.Source::new).bucket().build()).register();
        LIQUID_HYDROGEN = ((FluidBuilder)Northstar.REGISTRATE.standardFluid("liquid_hydrogen", SolidRenderedPlaceableFluidType.create(0xA59999, -553648129, () -> Float.valueOf(0.1f))).properties(b -> b.viscosity(2000).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(5).slopeFindDistance(3).explosionResistance(100.0f)).tag(new TagKey[]{NorthstarTags.NorthstarFluidTags.C_LIQUID_HYDROGEN.tag}).source(BaseFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.AllItemTags.BLAZE_BURNER_FUEL_SPECIAL.tag}).build()).register();
        LIQUID_OXYGEN = ((FluidBuilder)Northstar.REGISTRATE.standardFluid("liquid_oxygen", SolidRenderedPlaceableFluidType.create(9875375, -553648129, () -> Float.valueOf(0.1f))).properties(b -> b.viscosity(2000).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(5).slopeFindDistance(3).explosionResistance(100.0f)).tag(new TagKey[]{NorthstarTags.NorthstarFluidTags.C_LIQUID_OXYGEN.tag}).source(BaseFlowingFluid.Source::new).bucket().build()).register();
        METHANE = ((FluidBuilder)Northstar.REGISTRATE.standardFluid("methane", SolidRenderedPlaceableFluidType.create(4317326, -117440513, () -> Float.valueOf(0.1f))).properties(b -> b.viscosity(2000).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(5).slopeFindDistance(3).explosionResistance(100.0f)).tag(new TagKey[]{NorthstarTags.NorthstarFluidTags.C_METHANE.tag}).source(BaseFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.AllItemTags.BLAZE_BURNER_FUEL_REGULAR.tag}).build()).register();
        SULFURIC_ACID = ((FluidBuilder)Northstar.REGISTRATE.standardFluid("sulfuric_acid", SolidRenderedPlaceableFluidType.create(10873856, -1, () -> Float.valueOf(0.1f))).properties(b -> b.viscosity(2000).density(700)).fluidProperties(p -> p.levelDecreasePerBlock(1).tickRate(5).slopeFindDistance(3).explosionResistance(100.0f)).tag(new TagKey[]{NorthstarTags.NorthstarFluidTags.C_SULFURIC_ACID.tag}).source(BaseFlowingFluid.Source::new).bucket().build()).register();
        HYDROCARBON = ((FluidBuilder)Northstar.REGISTRATE.standardFluid("hydrocarbon", SolidRenderedPlaceableFluidType.create(460037, -1, () -> Float.valueOf(0.03125f))).lang("Liquid Hydrocarbons").properties(b -> b.viscosity(1000).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).tag(new TagKey[]{NorthstarTags.NorthstarFluidTags.C_HYDROCARBON.tag}).source(BaseFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.AllItemTags.BLAZE_BURNER_FUEL_REGULAR.tag}).build()).register();
        BIOFUEL = ((FluidBuilder)Northstar.REGISTRATE.standardFluid("biofuel", SolidRenderedPlaceableFluidType.create(0xFFFFFF, 0xFFFFFF, () -> Float.valueOf(0.03125f))).properties(b -> b.viscosity(1000).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).tag(new TagKey[]{NorthstarTags.NorthstarFluidTags.C_BIOFUEL.tag}).source(BaseFlowingFluid.Source::new).bucket().build()).register();
    }

    private static class SolidRenderedPlaceableFluidType
    extends TintedFluidType {
        private Vector3f fogColor;
        private int tintColor;
        private Supplier<Float> fogDistance;

        public static FluidBuilder.FluidTypeFactory create(int fogColor, int tintColor, Supplier<Float> fogDistance) {
            return (p, s, f) -> {
                SolidRenderedPlaceableFluidType fluidType = new SolidRenderedPlaceableFluidType(p, s, f);
                fluidType.fogColor = new Color(fogColor, false).asVectorF();
                fluidType.tintColor = tintColor;
                fluidType.fogDistance = fogDistance;
                return fluidType;
            };
        }

        private SolidRenderedPlaceableFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        @Override
        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        @Override
        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return this.tintColor;
        }

        @Override
        protected Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        @Override
        protected float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }
    }

    public static abstract class TintedFluidType
    extends FluidType {
        protected static final int NO_TINT = -1;
        private ResourceLocation stillTexture;
        private ResourceLocation flowingTexture;

        public TintedFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties);
            this.stillTexture = stillTexture;
            this.flowingTexture = flowingTexture;
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return stillTexture;
                }

                public ResourceLocation getFlowingTexture() {
                    return flowingTexture;
                }

                public int getTintColor(FluidStack stack) {
                    return this.getTintColor(stack);
                }

                public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                    return this.getTintColor(state, getter, pos);
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    Vector3f customFogColor = this.getCustomFogColor();
                    return customFogColor == null ? fluidFogColor : customFogColor;
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    float modifier = this.getFogDistanceModifier();
                    float baseWaterFog = 96.0f;
                    if (modifier != 1.0f) {
                        RenderSystem.setShaderFogShape((FogShape)FogShape.CYLINDER);
                        RenderSystem.setShaderFogStart((float)-8.0f);
                        RenderSystem.setShaderFogEnd((float)(baseWaterFog * modifier));
                    }
                }
            });
        }

        protected abstract int getTintColor(FluidStack var1);

        protected abstract int getTintColor(FluidState var1, BlockAndTintGetter var2, BlockPos var3);

        protected Vector3f getCustomFogColor() {
            return null;
        }

        protected float getFogDistanceModifier() {
            return 1.0f;
        }
    }
}

