/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.contraption.rocket;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.block.tech.rocket_station.RocketStationBlockEntity;
import com.lightning.northstar.contraption.rocket.RocketContraptionEntity;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber(modid="northstar")
public class RocketHandler {
    public static final List<RocketContraptionEntity> ROCKETS = new ArrayList<RocketContraptionEntity>();
    public static List<Pair<Level, BlockPos>> TICKET_QUEUE = new ArrayList<Pair<Level, BlockPos>>();
    public static HashMap<Pair<UUID, BlockPos>, Integer> CONTROL_QUEUE = new HashMap();
    public static long eventTickNumber;
    public static long eventTickNumberCheck;
    private static UUID pilotID;
    static int pp;
    public static final int DIMENSION_CHANGE_HEIGHT = 1750;

    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Pre event) {
        eventTickNumber = event.getLevel().getGameTime();
        if (!CONTROL_QUEUE.isEmpty() && eventTickNumber > eventTickNumberCheck) {
            HashMap<Pair<UUID, BlockPos>, Integer> destroy = new HashMap<Pair<UUID, BlockPos>, Integer>();
            for (Map.Entry<Pair<UUID, BlockPos>, Integer> entry : CONTROL_QUEUE.entrySet()) {
                RocketContraptionEntity rocket;
                Player player;
                if (entry.getKey().getFirst() == null || (player = event.getLevel().getPlayerByUUID((UUID)entry.getKey().getFirst())) == null || (rocket = (RocketContraptionEntity)event.getLevel().getEntity(entry.getValue().intValue())) == null) continue;
                if (rocket.getControllingPlayer().isPresent() && rocket.getControllingPlayer().get() == player.getUUID()) {
                    destroy.put(entry.getKey(), entry.getValue());
                    continue;
                }
                rocket.handlePlayerInteraction(player, (BlockPos)entry.getKey().getSecond(), Direction.NORTH, InteractionHand.MAIN_HAND);
                destroy.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<Object, Integer> entry : destroy.entrySet()) {
                CONTROL_QUEUE.remove(entry.getKey(), entry.getValue());
            }
        }
        if (event.getLevel().isClientSide) {
            return;
        }
        if (eventTickNumber > eventTickNumberCheck && !TICKET_QUEUE.isEmpty()) {
            ArrayList<Pair> DELETE_QUEUE = new ArrayList<Pair>();
            for (Pair pair : TICKET_QUEUE) {
                BlockEntity blockEntity;
                if (event.getLevel().dimension() != ((Level)pair.getFirst()).dimension() || !((blockEntity = ((Level)pair.getFirst()).getBlockEntity((BlockPos)pair.getSecond())) instanceof RocketStationBlockEntity)) continue;
                RocketStationBlockEntity rsbe = (RocketStationBlockEntity)blockEntity;
                rsbe.container.setItem(0, new ItemStack((ItemLike)Blocks.AIR.asItem()));
                DELETE_QUEUE.add(pair);
            }
            for (Pair pair : DELETE_QUEUE) {
                TICKET_QUEUE.remove(pair);
            }
        }
    }

    private static CompoundTag saveEntityData(Entity passenger) {
        CompoundTag nbt = new CompoundTag();
        return passenger.saveWithoutId(nbt);
    }

    private static void loadEntityData(Entity passenger, CompoundTag nbt, Map<UUID, Vec3> shipOffsetMap) {
        passenger.load(nbt);
        if (shipOffsetMap == null || !shipOffsetMap.containsKey(passenger.getUUID())) {
            Northstar.LOGGER.warn("Passenger {} DOES NOT has a ship offset", (Object)passenger);
        }
    }

    public static void deleteTicket(Level level, BlockPos pos) {
        TICKET_QUEUE.add((Pair<Level, BlockPos>)Pair.of((Object)level, (Object)pos.above()));
        eventTickNumberCheck = eventTickNumber + 3L;
    }

    public static boolean isInRocket(Entity entity) {
        return RocketHandler.getRocketThatContainsEntity(entity) != null;
    }

    public static RocketContraptionEntity getRocketThatContainsEntity(Entity entity) {
        for (RocketContraptionEntity rocket : ROCKETS) {
            if (!rocket.getEntitiesWithinContraption().contains(entity)) continue;
            return rocket;
        }
        return null;
    }

    public static void register() {
    }

    static {
        pp = 0;
    }
}

