/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.fluid;

import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;

public class TitaniumTetrachlorideBlock
extends LiquidBlock {
    public TitaniumTetrachlorideBlock(FlowingFluid fluid, BlockBehaviour.Properties properties) {
        super(fluid, properties);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        world.explode(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 3.0f, Level.ExplosionInteraction.NONE);
        BlockPos.MutableBlockPos neighborPos = new BlockPos.MutableBlockPos();
        for (Direction direction : Iterate.directions) {
            BlockPos firePos;
            neighborPos.setWithOffset((Vec3i)pos, direction);
            BlockState neighbor = world.getBlockState((BlockPos)neighborPos);
            if (!neighbor.getBlock().isFlammable(neighbor, (BlockGetter)world, (BlockPos)neighborPos, Direction.UP) || !world.isEmptyBlock(firePos = neighborPos.above())) continue;
            world.setBlock(firePos, Blocks.FIRE.defaultBlockState(), 3);
        }
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        super.entityInside(state, world, pos, entity);
        if (entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            item.remove(Entity.RemovalReason.DISCARDED);
            world.playSound(null, item.blockPosition(), SoundEvents.LAVA_POP, SoundSource.BLOCKS, 0.5f, 1.0f);
            world.addParticle((ParticleOptions)ParticleTypes.SMOKE, item.getX(), item.getY(), item.getZ(), 0.1 * (world.random.nextDouble() - 0.5), 0.1 * (world.random.nextDouble() - 0.5), 0.1 * (world.random.nextDouble() - 0.5));
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (!world.isClientSide) {
                world.explode(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 3.0f, Level.ExplosionInteraction.NONE);
                living.hurt(world.damageSources().hotFloor(), 2.0f);
            }
        }
    }
}

