/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.mixin;

import com.lightning.northstar.advancements.NorthstarAdvancements;
import com.lightning.northstar.content.NorthstarFluids;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.world.dimension.NorthstarDimensions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public class OxygenAndTempEntityMixin {
    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    public void northstar$tick(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (entity instanceof ZombifiedPiglin || entity.level().isClientSide()) {
            return;
        }
        ResourceKey dim = entity.level().dimension();
        if (entity.level() instanceof ServerLevel && entity instanceof Player) {
            Player player = (Player)entity;
            if (dim == NorthstarDimensions.MOON_DIM_KEY && !NorthstarAdvancements.ONE_SMALL_STEP.isAlreadyAwardedTo(player)) {
                if (player.level().getBlockState(player.blockPosition().below()).is(NorthstarTags.NorthstarBlockTags.MOON_BLOCKS.tag)) {
                    NorthstarAdvancements.ONE_SMALL_STEP.awardTo(player);
                }
            } else if (dim == NorthstarDimensions.MARS_DIM_KEY && !NorthstarAdvancements.ONE_GIANT_LEAP.isAlreadyAwardedTo(player) && player.level().getBlockState(player.blockPosition().below()).is(NorthstarTags.NorthstarBlockTags.MARS_BLOCKS.tag)) {
                NorthstarAdvancements.ONE_GIANT_LEAP.awardTo(player);
            }
        }
        if (this.getFluidAtPos((Entity)entity, entity.level()) == NorthstarFluids.SULFURIC_ACID.get() || this.getFluidAtPos((Entity)entity, entity.level()) == NorthstarFluids.SULFURIC_ACID.getSource().getSource()) {
            this.sulfurBurn((Entity)entity, entity.getRandom());
        }
    }

    public void sulfurBurn(Entity entity, RandomSource rando) {
        if (entity.hurt(entity.level().damageSources().lava(), 6.0f)) {
            entity.playSound(SoundEvents.GENERIC_BURN, 0.4f, 2.0f + rando.nextFloat() * 0.4f);
        }
    }

    public Fluid getFluidAtPos(Entity entity, Level level) {
        float height = level.getBlockState(entity.blockPosition()).getFluidState().getType().getHeight(level.getFluidState(entity.blockPosition()), (BlockGetter)level, entity.blockPosition());
        if ((double)(height + (float)entity.blockPosition().getY()) > entity.position().y) {
            return level.getBlockState(entity.blockPosition()).getFluidState().getType();
        }
        return null;
    }
}

