/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.crops;

import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.content.NorthstarItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MartianFlowerBlock
extends BushBlock
implements BonemealableBlock {
    public static final int MAX_AGE = 2;
    public static final IntegerProperty AGE = BlockStateProperties.f_61406_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);

    public MartianFlowerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(2)));
    }

    public Item getSeedItem() {
        return (Item)NorthstarItems.MARS_TULIP_SEEDS.get();
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 2;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Vec3 vec3 = pState.m_60824_(pLevel, pPos);
        return SHAPE.m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
    }

    protected boolean m_6266_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return pState.m_204336_(BlockTags.f_144274_) || pState.m_60713_(Blocks.f_50093_) || pState.m_60713_((Block)NorthstarBlocks.MARS_SOIL.get()) || pState.m_60713_((Block)NorthstarBlocks.MARS_FARMLAND.get()) || pState.m_60713_((Block)NorthstarBlocks.MARTIAN_GRASS.get());
    }

    public boolean isMaxAge(BlockState pState) {
        return (Integer)pState.m_61143_((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    public boolean m_6724_(BlockState pState) {
        return !this.isMaxAge(pState);
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        int i;
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        if (pLevel.m_45524_(pPos, 0) >= 9 && (i = this.getAge(pState)) < this.getMaxAge()) {
            pLevel.m_7731_(pPos, this.getStateForAge(i + 1), 2);
        }
    }

    public BlockState getStateForAge(int pAge) {
        return (BlockState)this.m_49966_().m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(pAge));
    }

    protected int getAge(BlockState pState) {
        return (Integer)pState.m_61143_((Property)this.getAgeProperty());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{AGE});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Item playerItem = pContext.m_43723_().m_21120_(pContext.m_43724_()).m_41720_();
        if (playerItem == this.getSeedItem()) {
            return (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0));
        }
        return this.m_49966_();
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if (!this.isMaxAge(state)) {
            level.m_7731_(pos, this.getStateForAge(this.getAge(state) + 1), 2);
        }
    }
}

