/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.circuit_engraver;

import com.lightning.northstar.block.tech.circuit_engraver.EngravingBehaviour;
import com.lightning.northstar.block.tech.circuit_engraver.EngravingRecipe;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.item.NorthstarRecipeTypes;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class CircuitEngraverBlockEntity
extends KineticBlockEntity
implements EngravingBehaviour.EngravingBehaviourSpecifics {
    public EngravingBehaviour engravingBehaviour;
    private int sound;
    private static final RecipeWrapper engraverInv = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));

    public CircuitEngraverBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick() {
        super.tick();
        if (this.engravingBehaviour.running && this.sound++ % 80 == 0 && this.f_58857_ != null) {
            this.sound = 0;
            this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)NorthstarSounds.LASER_BURN.get(), SoundSource.BLOCKS, 0.5f, 0.5f);
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.engravingBehaviour = new EngravingBehaviour(this);
        behaviours.add((BlockEntityBehaviour)this.engravingBehaviour);
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.PRESS, AllAdvancements.COMPACTING, AllAdvancements.TRACK_CRAFTING});
    }

    @Override
    public boolean tryProcessInBasin(boolean simulate) {
        return false;
    }

    @Override
    public boolean tryProcessOnBelt(TransportedItemStack input, List<ItemStack> outputList, boolean simulate) {
        ItemStack created;
        Optional<EngravingRecipe> recipe = this.getRecipe(input.stack);
        if (!recipe.isPresent()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        EngravingBehaviour.particleItems.add(input.stack);
        List outputs = RecipeApplier.applyRecipeOn((Level)this.f_58857_, (ItemStack)(this.canProcessInBulk() ? input.stack : ItemHandlerHelper.copyStackWithSize((ItemStack)input.stack, (int)1)), (Recipe)((Recipe)recipe.get()));
        Iterator iterator = outputs.iterator();
        while (iterator.hasNext() && (created = (ItemStack)iterator.next()).m_41619_()) {
        }
        outputList.addAll(outputs);
        return true;
    }

    public float getRenderedHeadOffset(float partialTicks) {
        float offset = 0.0f;
        if (this.engravingBehaviour.running) {
            if (this.engravingBehaviour.runningTicks < 20) {
                int localTick = this.engravingBehaviour.runningTicks;
                float num = ((float)localTick + partialTicks) / 20.0f;
                num = (2.0f - Mth.m_14089_((float)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            } else if (this.engravingBehaviour.runningTicks <= 20) {
                offset = 1.0f;
            } else {
                int localTick = 40 - this.engravingBehaviour.runningTicks;
                float num = ((float)localTick - partialTicks) / 20.0f;
                num = (2.0f - Mth.m_14089_((float)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            }
        }
        return offset + 0.4375f;
    }

    public float getRenderedHeadRotationSpeed(float partialTicks) {
        float speed = this.getSpeed();
        if (this.engravingBehaviour.running) {
            if (this.engravingBehaviour.runningTicks < 15) {
                return speed;
            }
            if (this.engravingBehaviour.runningTicks <= 20) {
                return speed * 2.0f;
            }
            return speed;
        }
        return speed / 2.0f;
    }

    @Override
    public boolean tryProcessInWorld(ItemEntity itemEntity, boolean simulate) {
        ItemStack item = itemEntity.m_32055_();
        Optional<EngravingRecipe> recipe = this.getRecipe(item);
        if (!recipe.isPresent()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        ItemStack itemCreated = ItemStack.f_41583_;
        EngravingBehaviour.particleItems.add(item);
        if (this.canProcessInBulk() || item.m_41613_() == 1) {
            RecipeApplier.applyRecipeOn((ItemEntity)itemEntity, (Recipe)((Recipe)recipe.get()));
            itemCreated = itemEntity.m_32055_().m_41777_();
        } else {
            for (ItemStack result : RecipeApplier.applyRecipeOn((Level)this.f_58857_, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)item, (int)1), (Recipe)((Recipe)recipe.get()))) {
                if (itemCreated.m_41619_()) {
                    itemCreated = result.m_41777_();
                }
                ItemEntity created = new ItemEntity(this.f_58857_, itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), result);
                created.m_32060_();
                created.m_20256_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)this.f_58857_.f_46441_, (float)0.05f));
                this.f_58857_.m_7967_((Entity)created);
            }
            item.m_41774_(1);
        }
        return true;
    }

    public Optional<EngravingRecipe> getRecipe(ItemStack item) {
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.f_58857_, (ItemStack)item, NorthstarRecipeTypes.ENGRAVING.getType(), EngravingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return assemblyRecipe;
        }
        engraverInv.m_6836_(0, item);
        return NorthstarRecipeTypes.ENGRAVING.find(engraverInv, this.f_58857_);
    }

    @Override
    public boolean canProcessInBulk() {
        return false;
    }

    @Override
    public void onPressingCompleted() {
    }

    @Override
    public int getParticleAmount() {
        return 15;
    }

    @Override
    public float getKineticSpeed() {
        return this.getSpeed();
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.engravingBehaviour.running = compound.m_128471_("Running");
        this.engravingBehaviour.runningTicks = compound.m_128451_("Ticks");
        super.read(compound, clientPacket);
    }
}

