/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.circuit_engraver;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.lightning.northstar.block.tech.circuit_engraver.CircuitEngraverBlockEntity;
import com.lightning.northstar.content.NorthstarPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.Direction;

public class CircuitEngraverVisual
extends ShaftInstance<CircuitEngraverBlockEntity>
implements DynamicInstance {
    private final RotatingData crystalHead;
    private final RotatingData crystalLaser;

    public CircuitEngraverVisual(MaterialManager materialManager, CircuitEngraverBlockEntity entity) {
        super(materialManager, (KineticBlockEntity)entity);
        this.crystalHead = ((RotatingData)materialManager.defaultCutout().material(AllMaterialSpecs.ROTATING).getModel(NorthstarPartialModels.CIRCUIT_ENGRAVER_HEAD, this.getRenderedBlockState()).createInstance()).setRotationAxis(Direction.Axis.Y);
        this.crystalLaser = ((RotatingData)materialManager.defaultCutout().material(AllMaterialSpecs.ROTATING).getModel(NorthstarPartialModels.CIRCUIT_ENGRAVER_LASER).createInstance()).setRotationAxis(Direction.Axis.Y);
    }

    public void beginFrame() {
        boolean running = ((CircuitEngraverBlockEntity)this.blockEntity).engravingBehaviour.running;
        float speed = ((CircuitEngraverBlockEntity)this.blockEntity).getRenderedHeadRotationSpeed(AnimationTickHolder.getPartialTicks());
        this.crystalHead.setPosition(this.getInstancePosition()).setRotationalSpeed(speed * 0.5f);
        this.crystalLaser.setPosition(this.getInstancePosition()).nudge(0.0f, running ? -0.16f : 1.0E8f, 0.0f).setRotationalSpeed(speed / 1.5f);
    }

    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.crystalHead, this.crystalLaser});
    }

    public void remove() {
        super.remove();
        this.crystalHead.delete();
        this.crystalLaser.delete();
    }
}

