/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.combustion_engine;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.lightning.northstar.block.tech.combustion_engine.CombustionEngineBlockEntity;
import com.lightning.northstar.block.tech.combustion_engine.CombustionEngineVisual;
import com.lightning.northstar.block.tech.solar_panel.SolarPanelBlock;
import com.lightning.northstar.content.NorthstarPartialModels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class CombustionEngineRenderer
extends KineticBlockEntityRenderer<CombustionEngineBlockEntity> {
    public CombustionEngineRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(CombustionEngineBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (Backend.canUseInstancing((Level)be.m_58904_())) {
            return;
        }
        Direction facing = (Direction)be.m_58900_().m_61143_(SolarPanelBlock.HORIZONTAL_FACING);
        float time = AnimationTickHolder.getRenderTime() * be.getSpeed() * 0.005f;
        SuperByteBuffer shaft = CachedBufferer.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)be.m_58900_(), (Direction)facing.m_122424_());
        CombustionEngineRenderer.standardKineticRotationTransform((SuperByteBuffer)shaft, (KineticBlockEntity)be, (int)light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        this.renderPiston(be, ms, buffer, light, facing, NorthstarPartialModels.PISTON1, time + 0.0f);
        this.renderPiston(be, ms, buffer, light, facing, NorthstarPartialModels.PISTON2, time + 2.0f);
        this.renderPiston(be, ms, buffer, light, facing, NorthstarPartialModels.PISTON3, time + 4.0f);
        this.renderPiston(be, ms, buffer, light, facing, NorthstarPartialModels.PISTON4, time + 8.0f);
        this.renderPiston(be, ms, buffer, light, facing, NorthstarPartialModels.PISTON5, time + 10.0f);
        this.renderPiston(be, ms, buffer, light, facing, NorthstarPartialModels.PISTON6, time + 12.0f);
    }

    private void renderPiston(CombustionEngineBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light, Direction facing, PartialModel model, float time) {
        CachedBufferer.partialFacing((PartialModel)model, (BlockState)be.m_58900_(), (Direction)facing).translate(0.0, (double)CombustionEngineVisual.getPistonOffset(time), 0.0).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
    }
}

