/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.ice_box;

import com.lightning.northstar.block.tech.ice_box.IceBoxBlockEntity;
import com.lightning.northstar.item.NorthstarRecipeTypes;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.DummyCraftingContainer;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class FreezingRecipe
extends ProcessingRecipe<SmartInventory> {
    public static boolean match(IceBoxBlockEntity iceBox, Recipe<?> recipe) {
        FreezingRecipe FreezingRecipe2;
        FilteringBehaviour filter = iceBox.getFilter();
        if (filter == null) {
            return false;
        }
        boolean filterTest = filter.test(recipe.m_8043_(iceBox.m_58904_().m_9598_()));
        if (recipe instanceof FreezingRecipe && (FreezingRecipe2 = (FreezingRecipe)recipe).getRollableResults().isEmpty() && !FreezingRecipe2.getFluidResults().isEmpty()) {
            filterTest = filter.test((FluidStack)FreezingRecipe2.getFluidResults().get(0));
        }
        if (!filterTest) {
            return false;
        }
        return FreezingRecipe.apply(iceBox, recipe, true);
    }

    public static boolean apply(IceBoxBlockEntity iceBox, Recipe<?> recipe) {
        return FreezingRecipe.apply(iceBox, recipe, false);
    }

    private static boolean apply(IceBoxBlockEntity icebox, Recipe<?> recipe, boolean test) {
        boolean isFreezingRecipe = recipe instanceof FreezingRecipe;
        IItemHandler availableItems = (IItemHandler)icebox.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        IFluidHandler availableFluids = (IFluidHandler)icebox.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (availableItems == null || availableFluids == null) {
            return false;
        }
        ArrayList<ItemStack> recipeOutputItems = new ArrayList<ItemStack>();
        ArrayList<FluidStack> recipeOutputFluids = new ArrayList<FluidStack>();
        LinkedList ingredients = new LinkedList(recipe.m_7527_());
        NonNullList fluidIngredients = isFreezingRecipe ? ((FreezingRecipe)recipe).getFluidIngredients() : Collections.emptyList();
        for (boolean simulate : Iterate.trueAndFalse) {
            Object ingredient2;
            if (!simulate && test) {
                return true;
            }
            int[] extractedItemsFromSlot = new int[availableItems.getSlots()];
            int[] extractedFluidsFromTank = new int[availableFluids.getTanks()];
            block1: for (Object ingredient2 : ingredients) {
                for (int slot = 0; slot < availableItems.getSlots(); ++slot) {
                    ItemStack extracted;
                    if (simulate && availableItems.getStackInSlot(slot).m_41613_() <= extractedItemsFromSlot[slot] || !ingredient2.test(extracted = availableItems.extractItem(slot, 1, true))) continue;
                    if (!simulate) {
                        availableItems.extractItem(slot, 1, false);
                    }
                    int n = slot;
                    extractedItemsFromSlot[n] = extractedItemsFromSlot[n] + 1;
                    continue block1;
                }
                return false;
            }
            boolean fluidsAffected = false;
            ingredient2 = fluidIngredients.iterator();
            block3: while (ingredient2.hasNext()) {
                FluidIngredient fluidIngredient = (FluidIngredient)ingredient2.next();
                int amountRequired = fluidIngredient.getRequiredAmount();
                for (int tank = 0; tank < availableFluids.getTanks(); ++tank) {
                    FluidStack fluidStack = availableFluids.getFluidInTank(tank);
                    if (simulate && fluidStack.getAmount() <= extractedFluidsFromTank[tank] || !fluidIngredient.test(fluidStack)) continue;
                    int drainedAmount = Math.min(amountRequired, fluidStack.getAmount());
                    if (!simulate) {
                        fluidStack.shrink(drainedAmount);
                        fluidsAffected = true;
                    }
                    if ((amountRequired -= drainedAmount) != 0) continue;
                    int n = tank;
                    extractedFluidsFromTank[n] = extractedFluidsFromTank[n] + drainedAmount;
                    continue block3;
                }
                return false;
            }
            if (fluidsAffected) {
                ((SmartFluidTankBehaviour)icebox.getBehaviour(SmartFluidTankBehaviour.INPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                ((SmartFluidTankBehaviour)icebox.getBehaviour(SmartFluidTankBehaviour.OUTPUT)).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
            }
            if (simulate) {
                if (recipe instanceof FreezingRecipe) {
                    FreezingRecipe FreezingRecipe2 = (FreezingRecipe)recipe;
                    recipeOutputItems.addAll(FreezingRecipe2.rollResults());
                    recipeOutputFluids.addAll((Collection<FluidStack>)FreezingRecipe2.getFluidResults());
                    recipeOutputItems.addAll((Collection<ItemStack>)FreezingRecipe2.m_7457_((Container)icebox.getInputInventory()));
                } else {
                    recipeOutputItems.add(recipe.m_8043_(icebox.m_58904_().m_9598_()));
                    if (recipe instanceof CraftingRecipe) {
                        CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
                        recipeOutputItems.addAll((Collection<ItemStack>)craftingRecipe.m_7457_((Container)new DummyCraftingContainer(availableItems, extractedItemsFromSlot)));
                    }
                }
            }
            if (icebox.acceptOutputs(recipeOutputItems, recipeOutputFluids, simulate)) continue;
            return false;
        }
        return true;
    }

    protected FreezingRecipe(IRecipeTypeInfo type, ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super(type, params);
    }

    public FreezingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        this(NorthstarRecipeTypes.FREEZING, params);
    }

    protected int getMaxInputCount() {
        return 9;
    }

    protected int getMaxOutputCount() {
        return 4;
    }

    protected int getMaxFluidInputCount() {
        return 2;
    }

    protected int getMaxFluidOutputCount() {
        return 2;
    }

    protected boolean canRequireHeat() {
        return true;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public boolean matches(SmartInventory pContainer, Level pLevel) {
        return false;
    }
}

