/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.ice_box;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.block.tech.ice_box.FreezingRecipe;
import com.lightning.northstar.block.tech.ice_box.IceBoxBlock;
import com.lightning.northstar.block.tech.ice_box.IceBoxInventory;
import com.lightning.northstar.item.NorthstarRecipeTypes;
import com.lightning.northstar.world.NorthstarTemperature;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.IntAttached;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;

public class IceBoxBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    private boolean contentsChanged;
    public IceBoxInventory inputInventory = new IceBoxInventory(9, this);
    public SmartInventory outputInventory;
    public SmartFluidTankBehaviour inputTank;
    protected SmartFluidTankBehaviour outputTank;
    private FilteringBehaviour filtering;
    protected LazyOptional<IItemHandlerModifiable> itemCapability;
    protected LazyOptional<IFluidHandler> fluidCapability;
    private Couple<SmartInventory> invs;
    private Couple<SmartFluidTankBehaviour> tanks;
    int recipeBackupCheck;
    private RecipeWrapper wrapper;
    protected Recipe<?> currentRecipe;
    protected int recipeTemp;
    private static final Object freezingRecipesKey = new Object();
    public static final int OUTPUT_ANIMATION_TIME = 10;
    List<IntAttached<ItemStack>> visualizedOutputItems;
    List<IntAttached<FluidStack>> visualizedOutputFluids;

    public IceBoxBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inputInventory.whenContentsChanged($ -> {
            this.contentsChanged = true;
        });
        this.outputInventory = new IceBoxInventory(9, this).forbidInsertion().withMaxStackSize(64);
        this.contentsChanged = true;
        this.itemCapability = LazyOptional.of(() -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputInventory, this.outputInventory}));
        this.invs = Couple.create((Object)((Object)this.inputInventory), (Object)this.outputInventory);
        this.tanks = Couple.create((Object)this.inputTank, (Object)this.outputTank);
        this.visualizedOutputFluids = Collections.synchronizedList(new ArrayList());
        this.visualizedOutputItems = Collections.synchronizedList(new ArrayList());
        this.recipeBackupCheck = 20;
        this.wrapper = new RecipeWrapper((IItemHandlerModifiable)this.inputInventory);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.inputInventory.deserializeNBT(compound.m_128469_("InputItems"));
        this.outputInventory.deserializeNBT(compound.m_128469_("OutputItems"));
        if (!clientPacket) {
            return;
        }
        NBTHelper.iterateCompoundList((ListTag)compound.m_128437_("VisualizedItems", 10), c -> this.visualizedOutputItems.add((IntAttached<ItemStack>)IntAttached.with((int)10, (Object)ItemStack.m_41712_((CompoundTag)c))));
        NBTHelper.iterateCompoundList((ListTag)compound.m_128437_("VisualizedFluids", 10), c -> this.visualizedOutputFluids.add((IntAttached<FluidStack>)IntAttached.with((int)10, (Object)FluidStack.loadFluidStackFromNBT((CompoundTag)c))));
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("InputItems", (Tag)this.inputInventory.serializeNBT());
        compound.m_128365_("OutputItems", (Tag)this.outputInventory.serializeNBT());
        if (!clientPacket) {
            return;
        }
        compound.m_128365_("VisualizedItems", (Tag)NBTHelper.writeCompoundList(this.visualizedOutputItems, ia -> ((ItemStack)ia.getValue()).serializeNBT()));
        compound.m_128365_("VisualizedFluids", (Tag)NBTHelper.writeCompoundList(this.visualizedOutputFluids, ia -> ((FluidStack)ia.getValue()).writeToNBT(new CompoundTag())));
        this.visualizedOutputItems.clear();
        this.visualizedOutputFluids.clear();
    }

    public boolean acceptOutputs(List<ItemStack> outputItems, List<FluidStack> outputFluids, boolean simulate) {
        this.outputInventory.allowInsertion();
        this.outputTank.allowInsertion();
        boolean acceptOutputsInner = this.acceptOutputsInner(outputItems, outputFluids, simulate);
        this.outputInventory.forbidInsertion();
        this.outputTank.forbidInsertion();
        return acceptOutputsInner;
    }

    private boolean acceptOutputsInner(List<ItemStack> outputItems, List<FluidStack> outputFluids, boolean simulate) {
        BlockState blockState = this.m_58900_();
        if (!(blockState.m_60734_() instanceof IceBoxBlock)) {
            return false;
        }
        Direction direction = (Direction)blockState.m_61143_((Property)IceBoxBlock.FACING);
        if (direction != Direction.DOWN) {
            boolean externalTankNotPresent;
            InvManipulationBehaviour inserter;
            BlockEntity be = this.f_58857_.m_7702_(this.f_58858_.m_7495_().m_121945_(direction));
            InvManipulationBehaviour invManipulationBehaviour = inserter = be == null ? null : (InvManipulationBehaviour)BlockEntityBehaviour.get((BlockGetter)this.f_58857_, (BlockPos)be.m_58899_(), (BehaviourType)InvManipulationBehaviour.TYPE);
            IItemHandler targetInv = be == null ? null : (IItemHandler)be.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).orElse(inserter == null ? null : (IItemHandler)inserter.getInventory());
            IFluidHandler targetTank = be == null ? null : (IFluidHandler)be.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_()).orElse(null);
            boolean bl = externalTankNotPresent = targetTank == null;
            if (!outputItems.isEmpty() && targetInv == null) {
                return false;
            }
            if (!outputFluids.isEmpty() && externalTankNotPresent) {
                targetTank = (IFluidHandler)this.outputTank.getCapability().orElse(null);
                if (targetTank == null) {
                    return false;
                }
                if (!this.acceptFluidOutputsIntoIceBox(outputFluids, simulate, targetTank)) {
                    return false;
                }
            }
            if (simulate) {
                return true;
            }
        }
        SmartInventory targetInv = this.outputInventory;
        IFluidHandler targetTank = (IFluidHandler)this.outputTank.getCapability().orElse(null);
        if (targetInv == null && !outputItems.isEmpty()) {
            return false;
        }
        if (!this.acceptItemOutputsIntoIceBox(outputItems, simulate, (IItemHandler)targetInv)) {
            return false;
        }
        if (outputFluids.isEmpty()) {
            return true;
        }
        if (targetTank == null) {
            return false;
        }
        return this.acceptFluidOutputsIntoIceBox(outputFluids, simulate, targetTank);
    }

    private boolean acceptFluidOutputsIntoIceBox(List<FluidStack> outputFluids, boolean simulate, IFluidHandler targetTank) {
        for (FluidStack fluidStack : outputFluids) {
            IFluidHandler.FluidAction action = simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
            int fill = targetTank instanceof SmartFluidTankBehaviour.InternalFluidHandler ? ((SmartFluidTankBehaviour.InternalFluidHandler)targetTank).forceFill(fluidStack.copy(), action) : targetTank.fill(fluidStack.copy(), action);
            if (fill == fluidStack.getAmount()) continue;
            return false;
        }
        return true;
    }

    private boolean acceptItemOutputsIntoIceBox(List<ItemStack> outputItems, boolean simulate, IItemHandler targetInv) {
        for (ItemStack itemStack : outputItems) {
            if (ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)itemStack.m_41777_(), (boolean)simulate).m_41619_()) continue;
            return false;
        }
        return true;
    }

    protected boolean updateRecipe() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return true;
        }
        List<Recipe<?>> recipes = this.getMatchingRecipes();
        if (recipes.isEmpty()) {
            return true;
        }
        this.currentRecipe = recipes.get(0);
        this.sendData();
        return true;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new IceBoxValueBox()).withCallback(newFilter -> {
            this.contentsChanged = true;
        }).forRecipes();
        behaviours.add((BlockEntityBehaviour)this.filtering);
        this.inputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.INPUT, (SmartBlockEntity)this, 2, 1000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        });
        this.outputTank = new SmartFluidTankBehaviour(SmartFluidTankBehaviour.OUTPUT, (SmartBlockEntity)this, 2, 1000, true).whenFluidUpdates(() -> {
            this.contentsChanged = true;
        }).forbidInsertion();
        behaviours.add((BlockEntityBehaviour)this.inputTank);
        behaviours.add((BlockEntityBehaviour)this.outputTank);
        this.fluidCapability = LazyOptional.of(() -> {
            LazyOptional inputCap = this.inputTank.getCapability();
            LazyOptional outputCap = this.outputTank.getCapability();
            return new CombinedTankWrapper(new IFluidHandler[]{(IFluidHandler)outputCap.orElse(null), (IFluidHandler)inputCap.orElse(null)});
        });
    }

    public float getTotalFluidUnits(float partialTicks) {
        int renderedFluids = 0;
        float totalUnits = 0.0f;
        SmartFluidTankBehaviour behaviour = this.inputTank;
        if (behaviour == null) {
            return 0.0f;
        }
        for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
            float units;
            if (tankSegment.getRenderedFluid().isEmpty() || (units = tankSegment.getTotalUnits(partialTicks)) < 1.0f) continue;
            totalUnits += units;
            ++renderedFluids;
        }
        if (renderedFluids == 0) {
            return 0.0f;
        }
        if (totalUnits < 1.0f) {
            return 0.0f;
        }
        return totalUnits;
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.updateRecipe();
        float temperature = NorthstarTemperature.getTemperatureAt(this.f_58857_, (Vec3i)this.f_58858_);
        float freezespeed = 0.0f;
        if (temperature <= 0.0f) {
            freezespeed = Math.abs(temperature) / 15.0f;
        }
        if (this.inputInventory.remainingTime <= 0.0f) {
            this.inputInventory.remainingTime = 500.0f;
        }
        this.inputInventory.remainingTime -= freezespeed;
        List<Recipe<?>> recipes = this.getMatchingRecipes();
        if (!recipes.isEmpty()) {
            this.currentRecipe = recipes.get(0);
        }
        if (this.currentRecipe != null && this.currentRecipe instanceof FreezingRecipe) {
            int n = this.recipeTemp = ((FreezingRecipe)this.currentRecipe).getProcessingDuration() > 0 ? ((FreezingRecipe)this.currentRecipe).getProcessingDuration() : 0;
        }
        if (temperature <= (float)(-this.recipeTemp) && this.inputInventory.remainingTime < 20.0f) {
            this.applyFreezingRecipe();
            if (!this.inputInventory.appliedRecipe) {
                this.applyRecipe();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 18);
            }
            this.inputInventory.remainingTime = 500.0f;
        }
        IItemHandlerModifiable items = (IItemHandlerModifiable)this.itemCapability.orElse((Object)new ItemStackHandler());
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack itemStack = items.getStackInSlot(i);
            this.visualizedOutputItems.add((IntAttached<ItemStack>)IntAttached.withZero((Object)itemStack));
        }
    }

    protected void applyFreezingRecipe() {
        if (this.currentRecipe == null) {
            return;
        }
        if (!FreezingRecipe.apply(this, this.currentRecipe)) {
            return;
        }
        this.inputTank.sendDataImmediately();
        this.outputTank.sendDataImmediately();
        if (this.matchFreezingRecipe(this.currentRecipe)) {
            this.sendData();
        }
        this.notifyChangeOfContents();
    }

    private void applyRecipe() {
        ArrayList list = new ArrayList();
        if (this.currentRecipe != null && this.currentRecipe instanceof FreezingRecipe) {
            int rolls = this.inputInventory.getStackInSlot(0).m_41613_();
            this.inputInventory.clearSlot(0);
            for (int roll = 0; roll < rolls; ++roll) {
                List rolledResults = ((FreezingRecipe)this.currentRecipe).rollResults();
                for (ItemStack stack : rolledResults) {
                    ItemHelper.addToList((ItemStack)stack, list);
                }
            }
            this.inputInventory.appliedRecipe = true;
            for (int slot = 0; slot < list.size() && slot + 1 < this.outputInventory.getSlots(); ++slot) {
                this.outputInventory.setStackInSlot(slot + 1, (ItemStack)list.get(slot));
            }
        }
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.f_58857_, (BlockPos)this.f_58858_, (IItemHandler)this.inputInventory);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void notifyUpdate() {
        super.notifyUpdate();
    }

    public void notifyChangeOfContents() {
        this.contentsChanged = true;
    }

    public FilteringBehaviour getFilter() {
        return this.filtering;
    }

    public boolean isEmpty() {
        return this.inputInventory.m_7983_() && this.inputTank.isEmpty() && this.outputInventory.m_7983_() && this.outputTank.isEmpty();
    }

    public void lazyTick() {
        super.lazyTick();
        if (!this.f_58857_.f_46443_) {
            if (this.recipeBackupCheck-- > 0) {
                return;
            }
            this.recipeBackupCheck = 20;
            if (this.isEmpty()) {
                return;
            }
            this.notifyChangeOfContents();
            return;
        }
    }

    public SmartInventory getInputInventory() {
        return this.inputInventory;
    }

    public void onWrenched(Direction face) {
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.translate((String)"gui.goggles.ice_box_contents", (Object[])new Object[0]).forGoggles(tooltip);
        IItemHandlerModifiable items = (IItemHandlerModifiable)this.itemCapability.orElse((Object)new ItemStackHandler());
        IFluidHandler fluids = (IFluidHandler)this.fluidCapability.orElse(null);
        boolean isEmpty = true;
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack stackInSlot = items.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            Lang.text((String)"").add(Component.m_237115_((String)stackInSlot.m_41778_()).m_130940_(ChatFormatting.GRAY)).add(Lang.text((String)(" x" + stackInSlot.m_41613_())).style(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (fluids != null) {
            LangBuilder mb = Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
            for (int b = 0; b < fluids.getTanks(); ++b) {
                FluidStack stackInSlot = fluids.getFluidInTank(b);
                if (stackInSlot.isEmpty()) continue;
                if (!stackInSlot.getFluid().getFluidType().isAir()) {
                    Lang.fluidName((FluidStack)stackInSlot).style(ChatFormatting.GRAY).forGoggles(tooltip);
                    Lang.builder().add(Lang.number((double)stackInSlot.getAmount()).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(Lang.number((double)fluids.getTankCapacity(b)).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
                }
                isEmpty = false;
            }
        }
        if (isEmpty) {
            tooltip.remove(0);
        }
        return true;
    }

    private Recipe<?> checkForIngredients(List<Recipe<?>> list) {
        for (Recipe<?> recipe : list) {
            if (!(recipe instanceof FreezingRecipe)) continue;
            int ingredAmount = 0;
            int requiredAmount = 0;
            int fluidamount = 0;
            int requiredFluid = 0;
            for (Ingredient ingred : ((FreezingRecipe)recipe).m_7527_()) {
                for (ItemStack item : ingred.m_43908_()) {
                    for (int i = 0; i < this.inputInventory.m_6643_(); ++i) {
                        if (this.inputInventory.m_8020_(i) == null || this.inputInventory.m_8020_(i).m_41613_() < item.m_41613_()) continue;
                        ++ingredAmount;
                    }
                    requiredAmount += item.m_41613_();
                }
            }
            for (Ingredient ingred : ((FreezingRecipe)recipe).getFluidIngredients()) {
                for (FluidStack item : ingred.getMatchingFluidStacks()) {
                    for (int i = 0; i < this.inputTank.getTanks().length; ++i) {
                        if (this.inputTank.getPrimaryHandler().getFluid() == null || this.inputTank.getPrimaryHandler().getFluid().getFluid() != item.getFluid() || this.inputTank.getPrimaryHandler().getFluidAmount() <= item.getAmount()) continue;
                        fluidamount += item.getAmount();
                    }
                    requiredFluid += item.getAmount();
                }
            }
            if (ingredAmount < requiredAmount || fluidamount < requiredFluid) continue;
            return recipe;
        }
        return null;
    }

    private void itemInserted(ItemStack stack) {
        List<Recipe<?>> recipes = this.getMatchingRecipes();
        if (!recipes.isEmpty()) {
            this.currentRecipe = recipes.get(0);
        }
        Northstar.LOGGER.debug("Searching for recipe!");
        this.inputInventory.remainingTime = 500.0f;
        this.inputInventory.appliedRecipe = false;
    }

    protected List<Recipe<?>> getMatchingRecipes() {
        List<Recipe<?>> matchingRecipes = this.getMatchingRecipes2();
        if (this.isEmpty()) {
            return matchingRecipes;
        }
        IItemHandler availableItems = (IItemHandler)this.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        if (availableItems == null) {
            return matchingRecipes;
        }
        return matchingRecipes;
    }

    protected List<Recipe<?>> getMatchingRecipes2() {
        if (Optional.of(this).map(IceBoxBlockEntity::isEmpty).orElse(true).booleanValue()) {
            return new ArrayList();
        }
        List list = RecipeFinder.get((Object)this.getRecipeCacheKey(), (Level)this.f_58857_, this::matchStaticFilters);
        return list.stream().filter(this::matchFreezingRecipe).sorted((r1, r2) -> r2.m_7527_().size() - r1.m_7527_().size()).collect(Collectors.toList());
    }

    protected <C extends Container> boolean matchStaticFilters(Recipe<C> recipe) {
        return recipe.m_6671_() == NorthstarRecipeTypes.FREEZING.getType();
    }

    protected Object getRecipeCacheKey() {
        return freezingRecipesKey;
    }

    protected <C extends Container> boolean matchFreezingRecipe(Recipe<C> recipe) {
        if (recipe == null) {
            return false;
        }
        return FreezingRecipe.match(this, recipe);
    }

    static class IceBoxValueBox
    extends ValueBoxTransform.Sided {
        IceBoxValueBox() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)12.0, (double)16.05);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction.m_122434_().m_122479_();
        }
    }
}

