/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.oxygen_concentrator;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.lightning.northstar.block.tech.oxygen_concentrator.OxygenConcentratorBlockEntity;
import com.lightning.northstar.content.NorthstarPartialModels;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import net.minecraft.core.Direction;

public class OxygenConcentratorVisual
extends KineticBlockEntityInstance<OxygenConcentratorBlockEntity>
implements DynamicInstance {
    private final RotatingData shaft;
    private final RotatingData propeller;

    public OxygenConcentratorVisual(MaterialManager materialManager, OxygenConcentratorBlockEntity entity) {
        super(materialManager, (KineticBlockEntity)entity);
        this.shaft = (RotatingData)((RotatingData)materialManager.defaultSolid().material(AllMaterialSpecs.ROTATING).getModel(AllPartialModels.SHAFT_HALF, entity.m_58900_(), Direction.DOWN).createInstance()).setRotationAxis(Direction.Axis.Y).setPosition(this.getInstancePosition());
        this.propeller = (RotatingData)((RotatingData)materialManager.defaultCutout().material(AllMaterialSpecs.ROTATING).getModel(NorthstarPartialModels.OXYGEN_CONCENTATOR_FAN).createInstance()).setRotationAxis(Direction.Axis.Y).setPosition(this.getInstancePosition());
    }

    public void beginFrame() {
        this.shaft.setRotationalSpeed(((OxygenConcentratorBlockEntity)this.blockEntity).getSpeed());
        this.propeller.setRotationalSpeed(((OxygenConcentratorBlockEntity)this.blockEntity).getSpeed() * 0.25f);
    }

    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.shaft, this.propeller});
    }

    protected void remove() {
        this.shaft.delete();
        this.propeller.delete();
    }
}

