/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.block.tech.oxygen_sealer;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.block.tech.oxygen_sealer.MovingOxygenSealer;
import com.lightning.northstar.block.tech.oxygen_sealer.OxygenSealerBlock;
import com.lightning.northstar.client.TilingAnchor;
import com.lightning.northstar.config.NorthstarConfigs;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.content.NorthstarFluids;
import com.lightning.northstar.util.NorthstarLang;
import com.lightning.northstar.world.NorthstarOxygen;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

@OnlyIn(value=Dist.CLIENT)
public class OxygenSealerScreen
extends AbstractSimiScreen {
    private static final ResourceLocation BACKGROUND = Northstar.asResource("textures/gui/oxygen_sealer.png");
    private final MovingOxygenSealer sealer;

    public OxygenSealerScreen(MovingOxygenSealer sealer) {
        super((Component)((OxygenSealerBlock)((Object)NorthstarBlocks.OXYGEN_SEALER.get())).m_49954_());
        this.sealer = sealer;
        this.setWindowSize(204, 64);
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        String remainingTime;
        graphics.m_280163_(BACKGROUND, this.guiLeft, this.guiTop, 0.0f, 0.0f, this.windowWidth, this.windowHeight, 256, 64);
        int totalOxygen = 0;
        int totalCapacity = 0;
        IFluidHandler fluids = this.sealer.contraption.getSharedFluidTanks();
        for (int i = 0; i < fluids.getTanks(); ++i) {
            FluidStack stack = fluids.getFluidInTank(i);
            if (NorthstarOxygen.isOxygen(stack.getFluid())) {
                totalOxygen += stack.getAmount();
                totalCapacity += fluids.getTankCapacity(i);
                continue;
            }
            if (!stack.isEmpty()) continue;
            totalCapacity += fluids.getTankCapacity(i);
        }
        float usagePerTick = (float)this.sealer.sealer.getSealedBlockCount() * NorthstarConfigs.server().oxygenSealerOxygenPerBlockPerTick.getF();
        int remainingTicks = usagePerTick <= 1.0E-5f ? Integer.MAX_VALUE : Mth.m_14143_((float)((float)totalOxygen / usagePerTick));
        int remainingSeconds = remainingTicks / 20;
        String string = remainingTicks == Integer.MAX_VALUE ? "Forever" : (remainingTime = remainingSeconds >= 3600 ? "%d:%02d:%02d".formatted(remainingSeconds / 60 / 60, remainingSeconds / 60 % 60, remainingSeconds % 60) : "%02d:%02d".formatted(remainingSeconds / 60, remainingSeconds % 60));
        MutableComponent status = this.sealer.sealer.hasLeak() ? Component.m_237115_((String)"northstar.gui.goggles.sealer.area_too_big").m_130940_(ChatFormatting.RED) : (this.sealer.active ? Component.m_237115_((String)"northstar.gui.oxygen_sealer.sealed").m_130940_(ChatFormatting.GREEN) : Component.m_237115_((String)"northstar.gui.oxygen_sealer.no_oxygen").m_130940_(ChatFormatting.GOLD));
        MutableComponent line1 = Component.m_237115_((String)"northstar.generic.status").m_7220_((Component)status);
        MutableComponent line2 = NorthstarLang.translate("gui.goggles.sealer.blocks_filled", new Object[0]).add(Lang.number((double)this.sealer.sealer.getSealedBlockCount()).style(ChatFormatting.AQUA)).component();
        MutableComponent line3 = NorthstarLang.translate("gui.oxygen_sealer.oxygen_usage", new Object[0]).add(Lang.number((double)usagePerTick).style(ChatFormatting.AQUA).add(NorthstarLang.MB_PER_TICK)).component();
        MutableComponent line4 = NorthstarLang.translate("gui.oxygen_sealer.available_oxygen", new Object[0]).add(Lang.number((double)totalOxygen).add(NorthstarLang.MB).style(ChatFormatting.AQUA)).component();
        MutableComponent line5 = NorthstarLang.translate("gui.oxygen_sealer.remaining_time", new Object[0]).add(Lang.text((String)remainingTime).style(ChatFormatting.AQUA)).component();
        TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(IClientFluidTypeExtensions.of((Fluid)((Fluid)NorthstarFluids.OXYGEN.get())).getStillTexture());
        int barHeight = 48;
        float fraction = totalCapacity == 0 ? (totalOxygen == 0 ? 0.0f : 1.0f) : (float)totalOxygen / (float)totalCapacity;
        int height = (int)((float)barHeight * fraction);
        graphics.northstar$blitRepeating(texture, this.guiLeft + 180, this.guiTop + 8 + barHeight - height, 16, height, TilingAnchor.BOTTOM_LEFT);
        graphics.m_280430_(this.f_96547_, (Component)line1, this.guiLeft + 5, this.guiTop + 7, -1);
        graphics.m_280430_(this.f_96547_, (Component)line2, this.guiLeft + 5, this.guiTop + 17, -1);
        graphics.m_280430_(this.f_96547_, (Component)line3, this.guiLeft + 5, this.guiTop + 27, -1);
        graphics.m_280430_(this.f_96547_, (Component)line4, this.guiLeft + 5, this.guiTop + 37, -1);
        graphics.m_280430_(this.f_96547_, (Component)line5, this.guiLeft + 5, this.guiTop + 47, -1);
    }
}

