/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.contraption.rocket;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.block.tech.computer_rack.TargetingComputerRackBlockEntity;
import com.lightning.northstar.block.tech.jet_engine.JetEngineBlock;
import com.lightning.northstar.block.tech.rocket_station.RocketStationBlockEntity;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.content.NorthstarContraptionTypes;
import com.lightning.northstar.content.NorthstarItems;
import com.lightning.northstar.content.NorthstarTags;
import com.lightning.northstar.data.FuelType;
import com.lightning.northstar.world.dimension.NorthstarPlanets;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.ContraptionType;
import com.simibubi.create.content.contraptions.TranslatingContraption;
import com.simibubi.create.content.contraptions.minecart.TrainCargoManager;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.apache.commons.lang3.tuple.Pair;

public class RocketContraption
extends TranslatingContraption {
    public int fuelCost = 0;
    public int fuelReturnCost = 0;
    public int weightCost = 0;
    public int heatShielding = 0;
    public int blockCount = 0;
    private boolean rocket_station = false;
    public boolean hasControls = false;
    public boolean hasInterplanetaryNavigation = false;
    public boolean hasAutoLander = false;
    public boolean isUsingTicket;
    private float fuelAmount = 0.0f;
    private int jet_engines = 0;
    private int visual_jet_engines = 0;
    public float computingPower = 0.0f;
    private List<BlockPos> assembledJets = new ArrayList<BlockPos>();
    public String name = "Rocket";
    public Player owner;
    public BlockPos localControlsPos;
    public ResourceKey<Level> dest = null;

    public RocketContraption() {
        this.storage = new TrainCargoManager();
    }

    public boolean assemble(Level world, BlockPos pos) throws AssemblyException {
        if (!this.searchMovedStructure(world, pos, null)) {
            return false;
        }
        System.out.print(this.blocks.size());
        this.startMoving(world);
        return true;
    }

    public void burnFuel(Level level) {
        IFluidHandler tanks = this.storage.getFluids();
        float fuelToBurn = (float)this.weightCost + (float)this.fuelCost * (1.0f - this.computingPower);
        for (int slot = 0; slot < tanks.getTanks(); ++slot) {
            FluidStack stack = tanks.getFluidInTank(slot);
            FuelType fuel = FuelType.getFuelType(level.m_9598_(), stack.getFluid());
            if (fuel == null || !((float)stack.getAmount() >= fuel.rocketMultiplier())) continue;
            float toBurn = Math.min(fuelToBurn / fuel.rocketMultiplier(), (float)stack.getAmount());
            stack.shrink((int)toBurn);
            fuelToBurn -= toBurn;
            if (!(fuelToBurn < 1.0f)) continue;
            return;
        }
    }

    protected Pair<StructureTemplate.StructureBlockInfo, BlockEntity> capture(Level world, BlockPos pos) {
        TargetingComputerRackBlockEntity crbe;
        BlockEntity ent;
        BlockState blockState = world.m_8055_(pos);
        if (NorthstarBlocks.ROCKET_STATION.has(blockState)) {
            this.rocket_station = true;
            ent = world.m_7702_(pos);
            if (ent instanceof RocketStationBlockEntity) {
                RocketStationBlockEntity rsbe = (RocketStationBlockEntity)ent;
                this.name = rsbe.name;
                if (rsbe.container.m_8020_(0).m_150930_((Item)NorthstarItems.RETURN_TICKET.get()) && rsbe.container.m_8020_(0).m_41737_("Planet") != null) {
                    if (NorthstarPlanets.getPlanetDimension(rsbe.container.m_8020_(0).m_41737_("Planet").m_128461_("name")) == this.dest) {
                        this.isUsingTicket = true;
                    }
                    this.isUsingTicket = true;
                }
            }
        }
        if (blockState.m_60713_((Block)NorthstarBlocks.AUTO_LANDER.get())) {
            Northstar.LOGGER.debug("AUTO LANDER");
            this.hasAutoLander = true;
        }
        if (blockState.m_60713_((Block)NorthstarBlocks.INTERPLANETARY_NAVIGATOR.get())) {
            this.hasInterplanetaryNavigation = true;
        }
        if (NorthstarBlocks.COMPUTER_RACK.has(blockState) && (ent = world.m_7702_(pos)) instanceof TargetingComputerRackBlockEntity) {
            crbe = (TargetingComputerRackBlockEntity)ent;
            for (int b = 0; b < crbe.container.m_6643_(); ++b) {
                if (!crbe.container.m_8020_(b).m_150930_((Item)NorthstarItems.TARGETING_COMPUTER.get()) || !((double)this.computingPower < 0.4)) continue;
                this.computingPower = (float)((double)this.computingPower + 0.0025);
            }
        }
        if (NorthstarBlocks.ROCKET_CONTROLS.has(blockState)) {
            this.hasControls = true;
            if (this.localControlsPos == null) {
                this.localControlsPos = this.toLocalPos(pos);
            }
        }
        if (blockState.m_60734_() instanceof JetEngineBlock) {
            ++this.jet_engines;
            if (!((Boolean)blockState.m_61143_((Property)JetEngineBlock.BOTTOM)).booleanValue()) {
                ++this.visual_jet_engines;
            }
            this.assembledJets.add(this.toLocalPos(pos));
        }
        if ((crbe = world.m_7702_(pos)) instanceof FluidTankBlockEntity) {
            FluidTankBlockEntity tank = (FluidTankBlockEntity)crbe;
            if (Float.isFinite(this.fuelAmount)) {
                FluidTank tankInventory = (FluidTank)tank.getTankInventory();
                for (int i = 0; i < tankInventory.getTanks(); ++i) {
                    FuelType fuel = FuelType.getFuelType(world.m_9598_(), tankInventory.getFluidInTank(i).getFluid());
                    if (fuel == null) continue;
                    this.fuelAmount += (float)tankInventory.getFluidAmount() * fuel.rocketMultiplier();
                }
                if (blockState.m_60713_((Block)AllBlocks.CREATIVE_FLUID_TANK.get())) {
                    this.fuelAmount = Float.POSITIVE_INFINITY;
                }
            }
        }
        if (!blockState.m_60713_(Blocks.f_50016_) && !blockState.m_60713_(Blocks.f_50627_)) {
            ++this.blockCount;
        }
        if (blockState.m_204336_(NorthstarTags.NorthstarBlockTags.HEAVY_BLOCKS.tag) && !blockState.m_60713_(Blocks.f_50016_)) {
            this.weightCost += 5;
        } else if (blockState.m_204336_(NorthstarTags.NorthstarBlockTags.SUPER_HEAVY_BLOCKS.tag) && !blockState.m_60713_(Blocks.f_50016_)) {
            this.weightCost += 10;
        } else if (!blockState.m_60713_(Blocks.f_50016_)) {
            ++this.weightCost;
        }
        if (blockState.m_204336_(NorthstarTags.NorthstarBlockTags.TIER_1_HEAT_RESISTANCE.tag) && !blockState.m_60713_(Blocks.f_50016_)) {
            this.heatShielding += 3;
        }
        if (blockState.m_204336_(NorthstarTags.NorthstarBlockTags.TIER_2_HEAT_RESISTANCE.tag) && !blockState.m_60713_(Blocks.f_50016_)) {
            this.heatShielding += 8;
        }
        if (blockState.m_204336_(NorthstarTags.NorthstarBlockTags.TIER_3_HEAT_RESISTANCE.tag) && !blockState.m_60713_(Blocks.f_50016_)) {
            this.heatShielding += 20;
        }
        return super.capture(world, pos);
    }

    public boolean canBeStabilized(Direction facing, BlockPos localPos) {
        return false;
    }

    public ContraptionType getType() {
        return NorthstarContraptionTypes.ROCKET;
    }

    public boolean hasRocketStation() {
        return this.rocket_station;
    }

    public int hasJetEngine() {
        return this.jet_engines;
    }

    public int getVisualJetEngines() {
        return this.visual_jet_engines;
    }

    public float fuelAmount() {
        return this.fuelAmount;
    }

    public int heatShielding() {
        return this.heatShielding;
    }

    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return super.isAnchoringBlockAt(pos.m_121945_(Direction.DOWN));
    }
}

