/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity;

import com.lightning.northstar.Northstar;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MarsCobraEntity
extends Monster
implements GeoAnimatable {
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Attacking speed boost", 0.1, AttributeModifier.Operation.ADDITION);
    private final AnimatableInstanceCache animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int attackTick;
    private int lookedAt;

    public MarsCobraEntity(EntityType<? extends MarsCobraEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_274367_(1.0f);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public double getTick(Object object) {
        return this.f_19797_;
    }

    private PlayState predicate(AnimationState<MarsCobraEntity> event) {
        if (this.attackTick > 0) {
            --this.attackTick;
            event.getController().setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().then("bite", Animation.LoopType.PLAY_ONCE));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimationSpeed((double)event.getLimbSwingAmount()).setAnimation(RawAnimation.begin().thenLoop("walk"));
        } else {
            event.getController().setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    protected SoundEvent m_7515_() {
        super.m_7515_();
        return (SoundEvent)NorthstarSounds.MARS_COBRA_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)NorthstarSounds.MARS_COBRA_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)NorthstarSounds.MARS_COBRA_DEATH.get();
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.attackTick = 40;
        }
        super.m_7822_(pId);
    }

    public static boolean cobraSpawnRules(EntityType<MarsCobraEntity> cobra, LevelAccessor level, MobSpawnType spawntype, BlockPos pos, RandomSource rando) {
        int surfaceY = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_());
        BlockState state = level.m_8055_(pos.m_7495_());
        if (pos.m_123342_() >= surfaceY) {
            return false;
        }
        if ((double)pos.m_123342_() > (double)surfaceY / 1.5) {
            int light = level.m_46803_(pos);
            return light != 0 ? false : MarsCobraEntity.m_217057_(cobra, (LevelAccessor)level, (MobSpawnType)spawntype, (BlockPos)pos, (RandomSource)rando) && state.m_204336_(NorthstarTags.NorthstarBlockTags.NATURAL_MARS_BLOCKS.tag);
        }
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
    }

    protected void m_8024_() {
        AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
        if (this.m_5448_() != null) {
            if (!attributeinstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
                attributeinstance.m_22118_(SPEED_MODIFIER_ATTACKING);
            }
        } else if (attributeinstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
            attributeinstance.m_22130_(SPEED_MODIFIER_ATTACKING);
        }
        super.m_8024_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new CobraLookForPlayerGoal(this, this::canTarget));
        this.f_21346_.m_25352_(1, (Goal)new CobraAttackWhenStaredAt(this));
        super.m_8099_();
    }

    public boolean m_7327_(Entity pEntity) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        this.m_5496_(SoundEvents.f_12357_, 1.0f, 1.0f);
        return super.m_7327_(pEntity);
    }

    boolean isLookingAtMe(Player pPlayer) {
        ItemStack itemstack = (ItemStack)pPlayer.m_150109_().f_35975_.get(3);
        if (itemstack.m_150930_(Blocks.f_50143_.m_5456_())) {
            return false;
        }
        Vec3 vec3 = pPlayer.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(this.m_20185_() - pPlayer.m_20185_(), this.m_20188_() - pPlayer.m_20188_(), this.m_20189_() - pPlayer.m_20189_());
        double d0 = vec31.m_82553_();
        vec31 = vec31.m_82541_();
        double d1 = vec3.m_82526_(vec31);
        Northstar.LOGGER.debug("{}, comparer: {}", (Object)d1, (Object)(1.0 - 0.35 / (d0 / 8.0)));
        return d1 > 1.0 - 0.35 / (d0 / 8.0) && pPlayer.m_142582_((Entity)this);
    }

    boolean canTarget(LivingEntity target) {
        if (!this.m_6779_(target)) {
            return false;
        }
        return target.m_6095_() == EntityType.f_20532_;
    }

    static class CobraLookForPlayerGoal
    extends NearestAttackableTargetGoal<Player> {
        private final MarsCobraEntity cobra;
        @Nullable
        private Player pendingTarget;
        private int aggroTime;
        private int stareTimer;
        private final TargetingConditions startAggroTargetConditions;
        private final TargetingConditions continueAggroTargetConditions = TargetingConditions.m_148352_().m_148355_();

        public CobraLookForPlayerGoal(MarsCobraEntity coberuh, @Nullable Predicate<LivingEntity> pSelectionPredicate) {
            super((Mob)coberuh, Player.class, 10, false, false, pSelectionPredicate);
            this.cobra = coberuh;
            this.startAggroTargetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(p_32578_ -> coberuh.isLookingAtMe((Player)p_32578_));
        }

        public boolean m_8036_() {
            this.pendingTarget = this.cobra.m_9236_().m_45946_(this.startAggroTargetConditions, (LivingEntity)this.cobra);
            return this.pendingTarget != null;
        }

        public void m_8056_() {
            this.aggroTime = this.m_183277_(5);
            ++this.cobra.lookedAt;
        }

        public void m_8041_() {
            this.pendingTarget = null;
            super.m_8041_();
        }

        public boolean m_8045_() {
            if (this.pendingTarget != null) {
                if (!this.cobra.isLookingAtMe(this.pendingTarget)) {
                    return false;
                }
                this.stareTimer = Mth.m_14045_((int)(this.stareTimer + 1), (int)0, (int)120);
                Northstar.LOGGER.debug("{}", (Object)this.stareTimer);
                if (this.stareTimer >= 32) {
                    this.cobra.m_21391_((Entity)this.pendingTarget, 10.0f, 10.0f);
                    return true;
                }
                return false;
            }
            return this.f_26050_ != null && this.continueAggroTargetConditions.m_26885_((LivingEntity)this.cobra, this.f_26050_) ? true : super.m_8045_();
        }

        public void m_8037_() {
            if (this.cobra.m_5448_() == null) {
                super.m_26070_((LivingEntity)null);
            }
            if (this.pendingTarget != null) {
                if (!this.cobra.isLookingAtMe(this.pendingTarget)) {
                    this.stareTimer = Mth.m_14045_((int)this.stareTimer, (int)0, (int)(this.stareTimer - 1));
                    Northstar.LOGGER.debug("{}", (Object)this.stareTimer);
                }
                if (--this.aggroTime <= 0) {
                    this.f_26050_ = this.pendingTarget;
                    this.pendingTarget = null;
                    super.m_8056_();
                }
            }
            super.m_8037_();
        }
    }

    static class CobraAttackWhenStaredAt
    extends Goal {
        private final MarsCobraEntity cobra;
        @Nullable
        private LivingEntity target;

        public CobraAttackWhenStaredAt(MarsCobraEntity coberuh) {
            this.cobra = coberuh;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.target = this.cobra.m_5448_();
            if (!(this.target instanceof Player)) {
                return false;
            }
            double d0 = this.target.m_20280_((Entity)this.cobra);
            return !(d0 > 256.0) && this.cobra.isLookingAtMe((Player)this.target);
        }

        public void m_8056_() {
            this.cobra.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.cobra.m_21563_().m_24946_(this.target.m_20185_(), this.target.m_20188_(), this.target.m_20189_());
        }
    }
}

