/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.entity;

import com.lightning.northstar.block.crops.MartianFlowerBlock;
import com.lightning.northstar.block.crops.MartianTallFlowerBlock;
import com.lightning.northstar.block.simple.VenusMushroomBlock;
import com.lightning.northstar.content.NorthstarBlocks;
import com.lightning.northstar.content.NorthstarItems;
import com.lightning.northstar.content.NorthstarSounds;
import com.lightning.northstar.content.NorthstarTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class VenusVultureEntity
extends Monster
implements GeoAnimatable {
    private static final EntityDataAccessor<Byte> FLYING = SynchedEntityData.m_135353_(VenusVultureEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> IS_LANDING = SynchedEntityData.m_135353_(VenusVultureEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> IS_TAKING_OFF = SynchedEntityData.m_135353_(VenusVultureEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private final AnimatableInstanceCache animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @Nullable
    private BlockPos targetPosition;
    private int pollinationTimer = 0;
    private int rotationTimer = 400;
    private int flapTimer = 45;
    private float rotationModifier = 0.0f;
    private int timeForPathFinding = 400;
    private boolean pollinating = false;
    BlockPos anchorPoint = this.m_20183_();
    boolean floorOrCeiling;

    public VenusVultureEntity(EntityType<? extends VenusVultureEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public double getTick(Object object) {
        return this.f_19797_;
    }

    private PlayState predicate(AnimationState<VenusVultureEntity> event) {
        if (this.flapTimer > 0 && this.isFlying()) {
            event.getController().setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().thenLoop("flap"));
        } else if (!(!this.isFlying() || event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimationSpeed(2.0).setAnimation(RawAnimation.begin().thenLoop("fly"));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimationSpeed((double)event.getLimbSwingAmount()).setAnimation(RawAnimation.begin().thenLoop("walk"));
        } else {
            event.getController().setAnimationSpeed(1.0).setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
    }

    public static boolean vultureSpawnRules(EntityType<VenusVultureEntity> moth, LevelAccessor level, MobSpawnType spawntype, BlockPos pos, RandomSource rando) {
        BlockState state = level.m_8055_(pos.m_7495_());
        return state.m_204336_(NorthstarTags.NorthstarBlockTags.NATURAL_VENUS_BLOCKS.tag) && level.m_45527_(pos);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLYING, (Object)1);
        this.f_19804_.m_135372_(IS_LANDING, (Object)0);
        this.f_19804_.m_135372_(IS_TAKING_OFF, (Object)0);
    }

    protected SoundEvent m_7515_() {
        super.m_7515_();
        return (SoundEvent)NorthstarSounds.VENUS_VULTURE_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)NorthstarSounds.VENUS_VULTURE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)NorthstarSounds.VENUS_VULTURE_DIE.get();
    }

    public void m_7822_(byte pId) {
        super.m_7822_(pId);
        if (pId == 120) {
            this.setFlying(false);
        }
        if (pId == 150) {
            this.flapTimer = 45;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isFlying()) {
            this.m_20011_(new AABB(-0.8, 0.0, -0.8, 0.8, 0.9, 0.8).m_82386_(this.m_20185_(), this.m_20186_(), this.m_20189_()));
            this.m_20256_(this.m_20156_());
            if (this.rotationTimer > 0 && this.rotationModifier != 0.0f) {
                --this.rotationTimer;
                this.m_146926_(this.m_146909_() + this.rotationModifier);
                this.flapTimer = Mth.m_14045_((int)this.flapTimer, (int)0, (int)(this.flapTimer - 1));
                int surfaceDif = this.m_20183_().m_123342_() - this.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING, this.m_20183_().m_123341_(), this.m_20183_().m_123343_());
                Vec3 delta = this.m_20184_();
                if (this.isTakingOff() && surfaceDif < 15) {
                    this.m_20334_(delta.f_82479_, delta.f_82480_ + 0.9, delta.f_82481_);
                } else if (surfaceDif > 25) {
                    this.m_20334_(delta.f_82479_, delta.f_82480_ - 0.5, delta.f_82481_);
                } else if (surfaceDif < 15) {
                    this.m_20334_(delta.f_82479_, delta.f_82480_ + 0.5, delta.f_82481_);
                } else {
                    this.setTakingOff(false);
                }
                if (this.isLanding()) {
                    this.m_20334_(delta.f_82479_, delta.f_82480_ - 0.7, delta.f_82481_);
                    if (!this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60795_()) {
                        this.m_9236_().m_7605_((Entity)this, (byte)120);
                        this.setFlying(false);
                        this.setTakingOff(false);
                    }
                }
                if (this.m_9236_().f_46441_.m_188503_(3000) == 0) {
                    this.setIsLanding(true);
                }
            } else {
                this.rotationModifier = this.m_9236_().f_46441_.m_188501_();
                this.rotationModifier = Mth.m_14036_((float)this.rotationModifier, (float)0.2f, (float)0.8f);
                this.flapTimer = 45;
                this.rotationModifier = this.m_9236_().f_46441_.m_188499_() ? this.rotationModifier : this.rotationModifier * -1.0f;
                this.rotationTimer = this.m_9236_().f_46441_.m_216332_(300, 1500);
            }
            for (Player player : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(15.0))) {
                if (!this.isFood(player.m_21120_(InteractionHand.MAIN_HAND)) && !this.isFood(player.m_21120_(InteractionHand.OFF_HAND))) continue;
                this.setIsLanding(true);
            }
        } else {
            this.m_20011_(new AABB(-0.4, 0.0, -0.4, 0.4, 1.8, 0.4).m_82386_(this.m_20185_(), this.m_20186_(), this.m_20189_()));
            if (this.m_9236_().f_46441_.m_188503_(1000) == 0) {
                this.setFlying(true);
                this.setTakingOff(true);
                this.setIsLanding(false);
            }
        }
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.isFood(itemstack)) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
            this.usePlayerItem(pPlayer, pHand, itemstack);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    protected void usePlayerItem(Player player, InteractionHand hand, ItemStack stack) {
        if (this.isFood(stack)) {
            this.m_5496_(SoundEvents.f_11788_, 1.0f, 1.0f);
            this.targetPosition = this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING, this.m_20183_());
        }
    }

    public boolean isFood(ItemStack stack) {
        return stack.m_150930_(((VenusMushroomBlock)((Object)NorthstarBlocks.BLOOM_FUNGUS.get())).m_5456_());
    }

    protected void m_8024_() {
        super.m_8024_();
        BlockPos blockpos = this.m_20183_();
        if (this.isFlying()) {
            this.f_19789_ = 0.0f;
            if (!(this.targetPosition == null || this.m_9236_().m_46859_(this.targetPosition) && this.targetPosition.m_123342_() > this.m_9236_().m_141937_())) {
                this.targetPosition = null;
            }
            if (this.timeForPathFinding > 0) {
                this.timeForPathFinding = Mth.m_14045_((int)this.timeForPathFinding, (int)0, (int)(this.timeForPathFinding - 1));
            } else {
                this.targetPosition = null;
                this.timeForPathFinding = 400;
            }
            if (this.targetPosition == null || this.f_19796_.m_188503_(30) == 0 || this.targetPosition.m_203195_((Position)this.m_20182_(), 2.0) && !this.pollinating) {
                this.targetPosition = new BlockPos(this.m_146903_() + this.f_19796_.m_188503_(16) - this.f_19796_.m_188503_(16), this.m_146904_() + this.f_19796_.m_188503_(16) - this.f_19796_.m_188503_(16), this.m_146907_() + this.f_19796_.m_188503_(16) - this.f_19796_.m_188503_(16));
            }
            if (this.pollinating && this.targetPosition.m_203195_((Position)this.m_20182_(), 0.5)) {
                this.pollinating = false;
                this.pollinationTimer = 6000;
                if (this.m_9236_().m_8055_(this.targetPosition).m_60734_() instanceof MartianFlowerBlock) {
                    item = ((MartianFlowerBlock)this.m_9236_().m_8055_(this.targetPosition).m_60734_()).getSeedItem();
                    ItemEntity spawnedItem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)item, 1));
                    this.m_9236_().m_7967_((Entity)spawnedItem);
                } else if (this.m_9236_().m_8055_(this.targetPosition).m_60734_() instanceof MartianTallFlowerBlock) {
                    item = (Item)NorthstarItems.MARS_SPROUT_SEEDS.get();
                    ItemEntity spawnedItem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)item, 1));
                    this.m_9236_().m_7967_((Entity)spawnedItem);
                }
                this.targetPosition = null;
            }
            if (this.targetPosition != null) {
                double tX = (double)this.targetPosition.m_123341_() + 0.5 - this.m_20185_();
                double tY = (double)this.targetPosition.m_123342_() + 0.1 - this.m_20186_();
                double tZ = (double)this.targetPosition.m_123343_() + 0.5 - this.m_20189_();
                Vec3 vec3 = this.m_20184_();
                Vec3 vec31 = vec3.m_82520_((Math.signum(tX) * 0.5 - vec3.f_82479_) * (double)0.1f, (Math.signum(tY) * (double)0.7f - vec3.f_82480_) * (double)0.1f, (Math.signum(tZ) * 0.5 - vec3.f_82481_) * (double)0.1f);
                this.m_20256_(vec31);
                float f = (float)(Mth.m_14136_((double)vec31.f_82481_, (double)vec31.f_82479_) * 57.2957763671875) - 90.0f;
                float f1 = Mth.m_14177_((float)(f - this.m_146908_()));
                this.f_20902_ = 0.5f;
                this.m_146922_(this.m_146908_() + f1);
                if (this.f_19796_.m_188503_(300) == 0 && this.m_9236_().m_8055_(blockpos.m_7495_()).m_60796_((BlockGetter)this.m_9236_(), blockpos.m_7495_()) && !this.pollinating) {
                    this.setFlying(false);
                }
            }
        } else if (this.f_19796_.m_188503_(500) == 0) {
            this.setFlying(true);
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("flying", this.isFlying());
        pCompound.m_128379_("pollinating", this.pollinating);
        pCompound.m_128405_("pollinationTimer", this.pollinationTimer);
        pCompound.m_128405_("timeForPathFinding", this.timeForPathFinding);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("flying")) {
            this.setFlying(pCompound.m_128471_("flying"));
        }
        if (pCompound.m_128441_("pollinating")) {
            this.pollinating = pCompound.m_128471_("pollinating");
        }
        if (pCompound.m_128441_("pollinationTimer")) {
            this.pollinationTimer = pCompound.m_128451_("pollinationTimer");
        }
        if (pCompound.m_128441_("timeForPathFinding")) {
            this.timeForPathFinding = pCompound.m_128451_("timeForPathFinding");
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!this.m_9236_().f_46443_ && !this.isFlying()) {
            this.setFlying(true);
            this.setTakingOff(true);
            this.setIsLanding(false);
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean isFlying() {
        return ((Byte)this.f_19804_.m_135370_(FLYING) & 1) != 0;
    }

    public void setFlying(boolean flying) {
        if (flying) {
            this.f_19804_.m_135381_(FLYING, (Object)1);
            this.rotationModifier = this.m_9236_().f_46441_.m_188501_();
            this.rotationModifier = Mth.m_14036_((float)this.rotationModifier, (float)0.2f, (float)0.8f);
            this.flapTimer = 45;
            this.rotationModifier = this.m_9236_().f_46441_.m_188499_() ? this.rotationModifier : this.rotationModifier * -1.0f;
            this.m_9236_().m_7605_((Entity)this, (byte)-106);
        } else {
            this.f_19804_.m_135381_(FLYING, (Object)-2);
        }
    }

    public boolean isTakingOff() {
        return ((Byte)this.f_19804_.m_135370_(IS_TAKING_OFF) & 1) != 0;
    }

    public boolean isLanding() {
        return ((Byte)this.f_19804_.m_135370_(IS_LANDING) & 1) != 0;
    }

    public void setIsLanding(boolean flying) {
        if (flying) {
            this.f_19804_.m_135381_(IS_LANDING, (Object)1);
        } else {
            this.f_19804_.m_135381_(IS_LANDING, (Object)-2);
        }
    }

    public void setTakingOff(boolean flying) {
        if (flying) {
            this.f_19804_.m_135381_(IS_TAKING_OFF, (Object)1);
        } else {
            this.f_19804_.m_135381_(IS_TAKING_OFF, (Object)-2);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{((VenusMushroomBlock)((Object)NorthstarBlocks.BLOOM_FUNGUS.get())).m_5456_()}), false));
        super.m_8099_();
    }

    public boolean m_7327_(Entity pEntity) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        this.m_5496_(SoundEvents.f_12357_, 1.0f, 1.0f);
        return super.m_7327_(pEntity);
    }

    public AgeableMob getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }
}

