/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.features;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.lightning.northstar.world.features.configuration.AlienTreeConfig;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class ArgyreFeature
extends Feature<AlienTreeConfig> {
    public ArgyreFeature(Codec<AlienTreeConfig> codec) {
        super(codec);
    }

    private static boolean isVine(LevelSimulatedReader pLevel, BlockPos pPos) {
        return pLevel.m_7433_(pPos, state -> state.m_60713_(Blocks.f_50191_));
    }

    public static boolean isBlockWater(LevelSimulatedReader pLevel, BlockPos pPos) {
        return pLevel.m_7433_(pPos, state -> state.m_60713_(Blocks.f_49990_));
    }

    public static boolean isAirOrLeaves(LevelSimulatedReader pLevel, BlockPos pPos) {
        return pLevel.m_7433_(pPos, state -> state.m_60795_() || state.m_204336_(BlockTags.f_13035_));
    }

    private static void setBlockKnownShape(LevelWriter pLevel, BlockPos pPos, BlockState pState) {
        pLevel.m_7731_(pPos, pState, 19);
    }

    public static boolean validTreePos(LevelSimulatedReader pLevel, BlockPos pPos) {
        return true;
    }

    private boolean doPlace(WorldGenLevel pLevel, RandomSource pRandom, BlockPos pPos, BiConsumer<BlockPos, BlockState> pRootBlockSetter, BiConsumer<BlockPos, BlockState> pTrunkBlockSetter, BiConsumer<BlockPos, BlockState> pFoliageBlockSetter, AlienTreeConfig treeconfiguration, BiConsumer<BlockPos, BlockState> biconsumer_glow) {
        int i = treeconfiguration.trunkPlacer().m_226153_(pRandom);
        int k = i - 1;
        int l = treeconfiguration.foliagePlacer().m_214117_(pRandom, k);
        BlockPos blockpos = treeconfiguration.rootPlacer().map(placer -> placer.m_225891_(pPos, pRandom)).orElse(pPos);
        int i1 = Math.min(pPos.m_123342_(), blockpos.m_123342_());
        int j1 = Math.max(pPos.m_123342_(), blockpos.m_123342_()) + i + 1;
        if (i1 >= pLevel.m_141937_() + 1 && j1 <= pLevel.m_151558_()) {
            OptionalInt optionalint = treeconfiguration.minimumSize().m_68295_();
            int k1 = this.getMaxFreeTreeHeight((LevelSimulatedReader)pLevel, i, blockpos, treeconfiguration);
            treeconfiguration.trunkPlacer().placeTrunk((LevelSimulatedReader)pLevel, pTrunkBlockSetter, pRandom, k1, blockpos, treeconfiguration, biconsumer_glow);
            return true;
        }
        return false;
    }

    private int getMaxFreeTreeHeight(LevelSimulatedReader pLevel, int pTrunkHeight, BlockPos pTopPosition, AlienTreeConfig treeconfiguration) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= pTrunkHeight + 1; ++i) {
            int j = treeconfiguration.minimumSize().m_6133_(pTrunkHeight, i);
            for (int k = -j; k <= j; ++k) {
                for (int l = -j; l <= j; ++l) {
                    blockpos$mutableblockpos.m_122154_((Vec3i)pTopPosition, k, i, l);
                    if (treeconfiguration.trunkPlacer().m_226184_(pLevel, (BlockPos)blockpos$mutableblockpos) && (treeconfiguration.ignoreVines() || !ArgyreFeature.isVine(pLevel, (BlockPos)blockpos$mutableblockpos))) continue;
                    return i - 2;
                }
            }
        }
        return pTrunkHeight;
    }

    protected void m_5974_(LevelWriter pLevel, BlockPos pPos, BlockState pState) {
        ArgyreFeature.setBlockKnownShape(pLevel, pPos, pState);
    }

    public final boolean m_142674_(FeaturePlaceContext<AlienTreeConfig> pContext) {
        WorldGenLevel worldgenlevel = pContext.m_159774_();
        RandomSource randomsource = pContext.m_225041_();
        BlockPos blockpos = pContext.m_159777_();
        AlienTreeConfig treeconfiguration = (AlienTreeConfig)pContext.m_159778_();
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        HashSet set3 = Sets.newHashSet();
        HashSet set4 = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> biconsumer = (p_160555_, p_160556_) -> {
            set.add(p_160555_.m_7949_());
            worldgenlevel.m_7731_(p_160555_, p_160556_, 19);
        };
        BiConsumer<BlockPos, BlockState> biconsumer1 = (p_160548_, p_160549_) -> {
            set1.add(p_160548_.m_7949_());
            worldgenlevel.m_7731_(p_160548_, p_160549_, 19);
        };
        BiConsumer<BlockPos, BlockState> biconsumer2 = (p_160543_, p_160544_) -> {
            set2.add(p_160543_.m_7949_());
            worldgenlevel.m_7731_(p_160543_, p_160544_, 19);
        };
        BiConsumer<BlockPos, BlockState> biconsumer3 = (p_225290_, p_225291_) -> {
            set3.add(p_225290_.m_7949_());
            worldgenlevel.m_7731_(p_225290_, p_225291_, 19);
        };
        BiConsumer<BlockPos, BlockState> biconsumer_glow = (p_160548_, thing2) -> {
            set4.add(p_160548_.m_7949_());
            worldgenlevel.m_7731_(p_160548_, Blocks.f_50141_.m_49966_(), 19);
        };
        boolean flag = this.doPlace(worldgenlevel, randomsource, blockpos, biconsumer, biconsumer1, biconsumer2, treeconfiguration, biconsumer_glow);
        if (!(!flag || set1.isEmpty() && set2.isEmpty())) {
            if (!treeconfiguration.decorators().isEmpty()) {
                TreeDecorator.Context treedecorator$context = new TreeDecorator.Context((LevelSimulatedReader)worldgenlevel, biconsumer3, randomsource, (Set)set1, (Set)set2, (Set)set);
                treeconfiguration.decorators().forEach(p_225282_ -> p_225282_.m_214187_(treedecorator$context));
            }
            return BoundingBox.m_162378_((Iterable)Iterables.concat((Iterable)set, (Iterable)set1, (Iterable)set2, (Iterable)set3)).map(p_225270_ -> {
                DiscreteVoxelShape discretevoxelshape = ArgyreFeature.updateLeaves((LevelAccessor)worldgenlevel, p_225270_, set1, set3, set);
                StructureTemplate.m_74510_((LevelAccessor)worldgenlevel, (int)3, (DiscreteVoxelShape)discretevoxelshape, (int)p_225270_.m_162395_(), (int)p_225270_.m_162396_(), (int)p_225270_.m_162398_());
                return true;
            }).orElse(false);
        }
        return false;
    }

    private static DiscreteVoxelShape updateLeaves(LevelAccessor pLevel, BoundingBox pBox, Set<BlockPos> pRootPositions, Set<BlockPos> pTrunkPositions, Set<BlockPos> pFoliagePositions) {
        ArrayList list = Lists.newArrayList();
        BitSetDiscreteVoxelShape discretevoxelshape = new BitSetDiscreteVoxelShape(pBox.m_71056_(), pBox.m_71057_(), pBox.m_71058_());
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : Lists.newArrayList((Iterable)Sets.union(pTrunkPositions, pFoliagePositions))) {
            if (!pBox.m_71051_((Vec3i)blockpos)) continue;
            discretevoxelshape.m_142703_(blockpos.m_123341_() - pBox.m_162395_(), blockpos.m_123342_() - pBox.m_162396_(), blockpos.m_123343_() - pBox.m_162398_());
        }
        for (BlockPos blockpos1 : Lists.newArrayList(pRootPositions)) {
            if (pBox.m_71051_((Vec3i)blockpos1)) {
                discretevoxelshape.m_142703_(blockpos1.m_123341_() - pBox.m_162395_(), blockpos1.m_123342_() - pBox.m_162396_(), blockpos1.m_123343_() - pBox.m_162398_());
            }
            for (Direction direction : Direction.values()) {
                BlockState blockstate;
                blockpos$mutableblockpos.m_122159_((Vec3i)blockpos1, direction);
                if (pRootPositions.contains(blockpos$mutableblockpos) || !(blockstate = pLevel.m_8055_((BlockPos)blockpos$mutableblockpos)).m_61138_((Property)BlockStateProperties.f_61414_)) continue;
                ((Set)list.get(0)).add(blockpos$mutableblockpos.m_7949_());
                ArgyreFeature.setBlockKnownShape((LevelWriter)pLevel, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(1)));
                if (!pBox.m_71051_((Vec3i)blockpos$mutableblockpos)) continue;
                discretevoxelshape.m_142703_(blockpos$mutableblockpos.m_123341_() - pBox.m_162395_(), blockpos$mutableblockpos.m_123342_() - pBox.m_162396_(), blockpos$mutableblockpos.m_123343_() - pBox.m_162398_());
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos blockpos2 : set) {
                if (pBox.m_71051_((Vec3i)blockpos2)) {
                    discretevoxelshape.m_142703_(blockpos2.m_123341_() - pBox.m_162395_(), blockpos2.m_123342_() - pBox.m_162396_(), blockpos2.m_123343_() - pBox.m_162398_());
                }
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState blockstate1;
                    blockpos$mutableblockpos.m_122159_((Vec3i)blockpos2, direction1);
                    if (set.contains(blockpos$mutableblockpos) || set1.contains(blockpos$mutableblockpos) || !(blockstate1 = pLevel.m_8055_((BlockPos)blockpos$mutableblockpos)).m_61138_((Property)BlockStateProperties.f_61414_) || (k = ((Integer)blockstate1.m_61143_((Property)BlockStateProperties.f_61414_)).intValue()) <= l + 1) continue;
                    BlockState blockstate2 = (BlockState)blockstate1.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(l + 1));
                    ArgyreFeature.setBlockKnownShape((LevelWriter)pLevel, (BlockPos)blockpos$mutableblockpos, blockstate2);
                    if (pBox.m_71051_((Vec3i)blockpos$mutableblockpos)) {
                        discretevoxelshape.m_142703_(blockpos$mutableblockpos.m_123341_() - pBox.m_162395_(), blockpos$mutableblockpos.m_123342_() - pBox.m_162396_(), blockpos$mutableblockpos.m_123343_() - pBox.m_162398_());
                    }
                    set1.add(blockpos$mutableblockpos.m_7949_());
                }
            }
        }
        return discretevoxelshape;
    }
}

