/*
 * Decompiled with CFR 0.152.
 */
package com.lightning.northstar.world.sealer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.longs.LongLongPair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import software.bernie.geckolib.core.object.Color;

public interface SealerDebugVisualizer {
    public static final Noop NOOP = new Noop();

    public void addConnection(long var1, long var3);

    public void complete();

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack var1, MultiBufferSource var2);

    public static class Noop
    implements SealerDebugVisualizer {
        private Noop() {
        }

        @Override
        public void addConnection(long pos1, long pos2) {
        }

        @Override
        public void complete() {
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void render(PoseStack pose, MultiBufferSource buffer) {
        }
    }

    public static class Client
    implements SealerDebugVisualizer {
        private final int color = Color.HSBtoARGB((float)((float)Math.random()), (float)0.8f, (float)0.8f);
        private final BlockPos.MutableBlockPos tempPos1 = new BlockPos.MutableBlockPos();
        private final BlockPos.MutableBlockPos tempPos2 = new BlockPos.MutableBlockPos();
        private final List<LongLongPair> debugConnections = new ArrayList<LongLongPair>();
        private final List<LongLongPair> finalDebugConnections = new ArrayList<LongLongPair>();

        @Override
        public void addConnection(long pos1, long pos2) {
            this.debugConnections.add(LongLongPair.of((long)pos1, (long)pos2));
        }

        @Override
        public void complete() {
            this.finalDebugConnections.clear();
            this.finalDebugConnections.addAll(this.debugConnections);
            this.debugConnections.clear();
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void render(PoseStack pose, MultiBufferSource buffer) {
            VertexConsumer vc = buffer.m_6299_(RenderType.m_110504_());
            Matrix4f mp = pose.m_85850_().m_252922_();
            Matrix3f mn = pose.m_85850_().m_252943_();
            for (LongLongPair connection : this.finalDebugConnections) {
                this.tempPos1.m_122188_(connection.firstLong());
                this.tempPos2.m_122188_(connection.secondLong());
                float nx = this.tempPos2.m_123341_() - this.tempPos1.m_123341_();
                float ny = this.tempPos2.m_123342_() - this.tempPos1.m_123342_();
                float nz = this.tempPos2.m_123343_() - this.tempPos1.m_123343_();
                vc.m_252986_(mp, (float)this.tempPos1.m_123341_() + 0.5f, (float)this.tempPos1.m_123342_() + 0.5f, (float)this.tempPos1.m_123343_() + 0.5f).m_193479_(this.color).m_252939_(mn, nx, ny, nz).m_5752_();
                vc.m_252986_(mp, (float)this.tempPos2.m_123341_() + 0.5f, (float)this.tempPos2.m_123342_() + 0.5f, (float)this.tempPos2.m_123343_() + 0.5f).m_193479_(this.color).m_252939_(mn, nx, ny, nz).m_5752_();
            }
        }
    }
}

