/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.redev.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.PlantType;

public class CattailsBlock
extends DoublePlantBlock
implements SimpleWaterloggedBlock,
BonemealableBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty SEEDING = BooleanProperty.m_61465_((String)"seeding");

    public CattailsBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283915_).m_60918_(SoundType.f_56740_).m_60966_().m_60910_().m_222979_(BlockBehaviour.OffsetType.XZ).m_278166_(PushReaction.DESTROY));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SEEDING, (Comparable)Boolean.valueOf(false)));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.PLAINS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED, SEEDING});
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)SEEDING) == false && state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos upperPos;
        BlockState upperState;
        int effectiveRate;
        if (state.m_61143_((Property)f_52858_) != DoubleBlockHalf.LOWER) {
            return;
        }
        BlockPos below = pos.m_7495_();
        BlockState soil = level.m_8055_(below);
        boolean isMud = soil.m_60713_(Blocks.f_220864_);
        int baseTicks = 19200;
        int n = effectiveRate = isMud ? baseTicks / 2 : baseTicks;
        if (random.m_188503_(effectiveRate / 20) == 0 && (upperState = level.m_8055_(upperPos = pos.m_7494_())).m_60713_((Block)this) && upperState.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SEEDING, (Comparable)Boolean.valueOf(true)), 2);
            level.m_7731_(upperPos, (BlockState)upperState.m_61124_((Property)SEEDING, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)SEEDING)).booleanValue() && player.m_21120_(hand).m_41720_() == Items.f_42574_ && state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER) {
            if (!level.f_46443_) {
                int count = 3 + level.f_46441_.m_188503_(2);
                CattailsBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42401_, count));
                BlockPos lowerPos = pos.m_7495_();
                BlockState lowerState = level.m_8055_(lowerPos);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)SEEDING, (Comparable)Boolean.valueOf(false)), 2);
                if (lowerState.m_60713_((Block)this) && lowerState.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER) {
                    level.m_7731_(lowerPos, (BlockState)lowerState.m_61124_((Property)SEEDING, (Comparable)Boolean.valueOf(false)), 2);
                }
                level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 1.0f);
                player.m_21120_(hand).m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        if (pos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(pos.m_7494_()).m_60629_(context)) {
            boolean isWater = level.m_6425_(pos).m_76152_() == Fluids.f_76193_;
            return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
        }
        return null;
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER && (Boolean)state.m_61143_((Property)SEEDING) == false;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockPos lowerPos;
        BlockState lowerState;
        if (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER) {
            BlockPos upperPos = pos.m_7494_();
            BlockState upperState = level.m_8055_(upperPos);
            if (upperState.m_60713_((Block)this) && upperState.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)SEEDING, (Comparable)Boolean.valueOf(true)), 2);
                level.m_7731_(upperPos, (BlockState)upperState.m_61124_((Property)SEEDING, (Comparable)Boolean.valueOf(true)), 2);
            }
        } else if (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER && (lowerState = level.m_8055_(lowerPos = pos.m_7495_())).m_60713_((Block)this) && lowerState.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SEEDING, (Comparable)Boolean.valueOf(true)), 2);
            level.m_7731_(lowerPos, (BlockState)lowerState.m_61124_((Property)SEEDING, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_((Property)f_52858_);
        if (direction.m_122434_() == Direction.Axis.Y) {
            if (half == DoubleBlockHalf.LOWER && direction == Direction.UP && neighborState.m_60734_() != this) {
                return Blocks.f_50016_.m_49966_();
            }
            if (half == DoubleBlockHalf.UPPER && direction == Direction.DOWN && neighborState.m_60734_() != this) {
                return Blocks.f_50016_.m_49966_();
            }
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }
}

